/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.api;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.TaskEnchantmentEnum;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.mm.MythicMobUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.reward.RewardStrategy;
import com.handy.playertask.service.TaskCoinService;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.DemandReplaceUtil;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerTaskApi {
    private PlayerTaskApi() {
    }

    public static PlayerTaskApi getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public TaskList findDetailByTaskId(Integer taskId) {
        return TaskListService.getInstance().findDetailById(taskId).orElse(null);
    }

    public boolean reward(List<Player> playerList, List<Integer> taskRewardIdList) {
        RewardStrategy.getInstance().batchReward(playerList, taskRewardIdList);
        return true;
    }

    public Integer findAmountByPlayer(Player player) {
        return this.findAmountByPlayer(player.getUniqueId());
    }

    public Integer findAmountByPlayer(String playerName) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TaskCoinService.getInstance().findCoinByPlayer(offlinePlayer.getUniqueId());
    }

    public Integer findAmountByPlayer(UUID playerUuid) {
        return TaskCoinService.getInstance().findCoinByPlayer(playerUuid);
    }

    public boolean addCoin(Player player, Integer amount) {
        return this.addCoin(player.getName(), amount);
    }

    public boolean addCoin(String playerName, Integer amount) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TaskCoinService.getInstance().addCoin(offlinePlayer.getUniqueId(), amount);
    }

    public boolean addCoin(UUID playerUuid, Integer amount) {
        return TaskCoinService.getInstance().addCoin(playerUuid, amount);
    }

    public boolean subtractCoin(Player player, Integer amount) {
        return this.subtractCoin(player.getName(), amount);
    }

    public boolean subtractCoin(String playerName, Integer amount) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TaskCoinService.getInstance().subtractCoin(offlinePlayer.getUniqueId(), amount);
    }

    public boolean subtractCoin(UUID playerUuid, Integer amount) {
        return TaskCoinService.getInstance().subtractCoin(playerUuid, amount);
    }

    public boolean setCoin(Player player, Integer amount) {
        return this.setCoin(player.getName(), amount);
    }

    public boolean setCoin(String playerName, Integer amount) {
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(playerName);
        return TaskCoinService.getInstance().set(offlinePlayer.getUniqueId(), amount);
    }

    public boolean setCoin(UUID playerUuid, Integer amount) {
        return TaskCoinService.getInstance().set(playerUuid, amount);
    }

    public void sendTaskFinishMsg(Player player, String taskName) {
        String taskFinishMsg = BaseUtil.getMsgNotColor("taskFinish", "");
        if (StrUtil.isEmpty(taskFinishMsg)) {
            return;
        }
        MessageUtil.sendTitle(player, taskName, taskFinishMsg);
    }

    public void sendTaskManagerMsg(Player player, String taskName) {
        String taskManagerMsg = BaseUtil.getMsgNotColor("open.taskManager");
        if (StrUtil.isEmpty(taskManagerMsg)) {
            return;
        }
        taskManagerMsg = taskManagerMsg.replace("${taskName}", taskName);
        MessageUtil.sendActionbar(player, BaseUtil.replaceChatColor(taskManagerMsg));
    }

    public void sendCurrentProgressMsg(Player player, String demandType, Integer amount, Integer completionAmount, String content) {
        String msg;
        DemandTypeEnum demandTypeEnum = DemandTypeEnum.getEnumThrow(demandType);
        switch (demandTypeEnum) {
            case KILL: {
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + MythicMobUtil.getInstance().getMythicMobName(content);
                break;
            }
            case KILL_PLAYER: {
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + content;
                break;
            }
            case KILL_NORMAL: {
                String name = ConfigUtil.MONSTER_CONFIG.getString(content, BaseUtil.getEntityName(content));
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + name;
                break;
            }
            case BLOCK_BREAK: {
                ItemStack itemStack = ItemStackUtil.getItemStack(content);
                boolean isAgeAble = DemandReplaceUtil.isAgeAble(itemStack);
                String demand = isAgeAble ? BaseUtil.getMsgNotColor("demand.harvest") : DemandTypeEnum.getTypeName(demandTypeEnum.getType());
                String blockBreakDisplayName = BaseUtil.getDisplayName(itemStack);
                msg = demand + " " + completionAmount + "/" + amount + " " + blockBreakDisplayName;
                break;
            }
            case ENCHANTMENT: {
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + TaskEnchantmentEnum.getTypeName(content);
                break;
            }
            case SHEAR: {
                ItemStack shearItemStack = ItemStackUtil.getItemStack(content);
                String shearDisplayName = BaseUtil.getDisplayName(shearItemStack);
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + shearDisplayName;
                break;
            }
            default: {
                ItemStack itemStack = ItemStackUtil.itemStackDeserialize(content);
                String defaultDisplayName = BaseUtil.getDisplayName(itemStack);
                msg = DemandTypeEnum.getTypeName(demandTypeEnum.getType()) + " " + completionAmount + "/" + amount + " " + defaultDisplayName;
            }
        }
        MessageUtil.sendActionbar(player, msg);
    }

    private static class SingletonHolder {
        private static final PlayerTaskApi INSTANCE = new PlayerTaskApi();

        private SingletonHolder() {
        }
    }
}

