/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.command;

import com.handy.playertask.constants.PlayerTabListEnum;
import com.handy.playertask.constants.TabListEnum;
import com.handy.playertask.lib.annotation.HandyCommand;
import com.handy.playertask.lib.command.HandyCommandFactory;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;

@HandyCommand(name="playerTask")
public class PlayerTaskCommand
implements TabExecutor {
    private static final String PERMISSION = "playerTask.reload";

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length < 1) {
            return this.sendHelp(sender);
        }
        boolean rst = HandyCommandFactory.getInstance().onCommand(sender, cmd, label, args, BaseUtil.getMsgNotColor("noPermission"));
        if (!rst) {
            return this.sendHelp(sender);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<String> commands = PlayerTabListEnum.returnList(args, args.length);
        if (sender.hasPermission(PERMISSION)) {
            commands = TabListEnum.returnList(args, args.length);
        }
        if (commands == null) {
            return null;
        }
        StringUtil.copyPartialMatches((String)args[args.length - 1].toLowerCase(), commands, completions);
        Collections.sort(completions);
        return completions;
    }

    private Boolean sendHelp(CommandSender sender) {
        if (!sender.hasPermission(PERMISSION)) {
            return true;
        }
        List helps = ConfigUtil.LANG_CONFIG.getStringList("helps");
        for (String help : helps) {
            MessageUtil.sendMessage(sender, BaseUtil.replaceChatColor(help));
        }
        return true;
    }
}

