/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.command.admin;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.ShearTypeEnum;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.inventory.MythicMobGui;
import com.handy.playertask.lib.command.IHandyCommandEvent;
import com.handy.playertask.lib.util.AssertUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskDemandService;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class AddDemandCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "addDemand";
    }

    @Override
    public String permission() {
        return "playerTask.addDemand";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Integer amount = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        DemandTypeEnum demandTypeEnum = DemandTypeEnum.getEnumThrow(args[1]);
        TaskDemand taskDemand = new TaskDemand();
        taskDemand.setType(demandTypeEnum.getType());
        taskDemand.setAmount(amount);
        if (DemandTypeEnum.KILL.equals((Object)demandTypeEnum)) {
            this.kill(sender, args, player, taskDemand);
            return;
        }
        if (DemandTypeEnum.KILL_NORMAL.equals((Object)demandTypeEnum)) {
            this.killNormal(sender, args, taskDemand);
            return;
        }
        if (DemandTypeEnum.KILL_PLAYER.equals((Object)demandTypeEnum)) {
            this.killPlayer(sender, args, taskDemand);
            return;
        }
        if (DemandTypeEnum.ENCHANTMENT.equals((Object)demandTypeEnum)) {
            this.enchantment(sender, args, taskDemand);
            return;
        }
        if (DemandTypeEnum.SHEAR.equals((Object)demandTypeEnum)) {
            this.shear(sender, args, taskDemand);
            return;
        }
        ItemStack item = ItemStackUtil.getItemInMainHand(player.getInventory());
        AssertUtil.notTrue(Material.AIR.equals((Object)item.getType()), sender, BaseUtil.getMsgNotColor("noAir"));
        ItemStack itemInMainHand = item.clone();
        itemInMainHand.setAmount(1);
        if (DemandTypeEnum.BLOCK_BREAK.getType().equals(demandTypeEnum.getType())) {
            taskDemand.setItemStack(itemInMainHand.getType().name());
        } else {
            taskDemand.setItemStack(ItemStackUtil.itemStackSerialize(itemInMainHand));
        }
        boolean rst = TaskDemandService.getInstance().add(taskDemand);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }

    private void shear(CommandSender sender, String[] args, TaskDemand taskDemand) {
        AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        AssertUtil.isTrue(ShearTypeEnum.isExist(args[3]), sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
        taskDemand.setItemStack(args[3]);
        boolean rst = TaskDemandService.getInstance().add(taskDemand);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }

    private void enchantment(CommandSender sender, String[] args, TaskDemand taskDemand) {
        AssertUtil.notTrue(args.length < 5, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        AssertUtil.notNull(Enchantment.getByName((String)args[3]), sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
        int level = AssertUtil.isNumericToInt(args[4], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        taskDemand.setItemStack(args[3] + ":" + level);
        boolean rst = TaskDemandService.getInstance().add(taskDemand);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }

    private void killPlayer(CommandSender sender, String[] args, TaskDemand taskDemand) {
        AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        taskDemand.setItemStack(args[3]);
        boolean rst = TaskDemandService.getInstance().add(taskDemand);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }

    private void killNormal(CommandSender sender, String[] args, TaskDemand taskDemand) {
        AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        AssertUtil.notNull(EntityType.fromName((String)args[3]), sender, BaseUtil.getMsgNotColor("noNormalMob"));
        taskDemand.setItemStack(args[3].toLowerCase());
        boolean rst = TaskDemandService.getInstance().add(taskDemand);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }

    private void kill(CommandSender sender, String[] args, Player player, TaskDemand taskDemand) {
        if (args.length == 3) {
            Inventory inventory = MythicMobGui.getInstance().createGui(player);
            if (inventory == null) {
                MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noMythicMob"));
                return;
            }
            player.openInventory(inventory);
            BaseTaskConstants.MYTHIC_MOBS_MAP.put(player.getUniqueId(), taskDemand);
            return;
        }
        taskDemand.setItemStack(args[3]);
        boolean rst = TaskDemandService.getInstance().add(taskDemand);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }
}

