/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.command.admin;

import com.handy.playertask.constants.ShopTypeEnum;
import com.handy.playertask.entity.TaskShop;
import com.handy.playertask.lib.command.IHandyCommandEvent;
import com.handy.playertask.lib.util.AssertUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskShopService;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AddShopCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "addShop";
    }

    @Override
    public String permission() {
        return "playerTask.addShop";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Integer amount = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        TaskShop taskShop = new TaskShop();
        taskShop.setType(ShopTypeEnum.getEnumThrow(args[1]).getType());
        taskShop.setAmount(amount);
        ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
        AssertUtil.notTrue(Material.AIR.equals((Object)itemInMainHand.getType()), sender, BaseUtil.getMsgNotColor("noAir"));
        taskShop.setItemStack(ItemStackUtil.itemStackSerialize(itemInMainHand));
        boolean rst = TaskShopService.getInstance().add(taskShop);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }
}

