/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.command.admin;

import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskReel;
import com.handy.playertask.entity.TaskReelPlayerDemand;
import com.handy.playertask.lib.command.IHandyCommandEvent;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.util.AssertUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskDemandService;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.service.TaskReelPlayerDemandService;
import com.handy.playertask.service.TaskReelService;
import com.handy.playertask.util.TaskUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChangeItemCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "changeItem";
    }

    @Override
    public String permission() {
        return "playerTask.changeItem";
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        Optional<Player> playerOptional;
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Integer taskId = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Optional<TaskList> taskListOptional = TaskListService.getInstance().findById(taskId);
        AssertUtil.isTrue(taskListOptional.isPresent(), sender, BaseUtil.getMsgNotColor("noDataExist"));
        TaskList taskList = taskListOptional.get();
        if (args.length >= 3 && (playerOptional = BaseUtil.getOnlinePlayer(args[2])).isPresent()) {
            player = playerOptional.get();
        }
        TaskReel taskReel = new TaskReel();
        taskReel.setTaskId(taskList.getId());
        taskReel.setTaskName(taskList.getTaskName());
        taskReel.setPlayerName(player.getName());
        taskReel.setPlayerUuid(player.getUniqueId().toString());
        taskReel.setTaskDemand(taskList.getTaskDemand());
        taskReel.setTaskRewards(taskList.getTaskRewards());
        taskReel.setRarity(taskList.getRarity());
        taskReel.setStatus(false);
        taskReel.setDescription(taskList.getDescription());
        int taskReelId = TaskReelService.getInstance().add(taskReel);
        taskReel.setId(taskReelId);
        List<TaskDemand> taskDemandList = TaskDemandService.getInstance().findByIds(StrUtil.strToIntList(taskReel.getTaskDemand()));
        ArrayList<TaskReelPlayerDemand> taskReelPlayerDemands = new ArrayList<TaskReelPlayerDemand>();
        if (CollUtil.isNotEmpty(taskDemandList)) {
            for (TaskDemand taskDemand : taskDemandList) {
                TaskReelPlayerDemand taskReelPlayerDemand = new TaskReelPlayerDemand();
                taskReelPlayerDemand.setReelId(taskReelId);
                taskReelPlayerDemand.setPlayerName(taskReel.getPlayerName());
                taskReelPlayerDemand.setPlayerUuid(taskReel.getPlayerUuid());
                taskReelPlayerDemand.setType(taskDemand.getType());
                taskReelPlayerDemand.setCompletionAmount(0);
                taskReelPlayerDemand.setAmount(taskDemand.getAmount());
                taskReelPlayerDemand.setItemStack(taskDemand.getItemStack());
                taskReelPlayerDemands.add(taskReelPlayerDemand);
            }
            TaskReelPlayerDemandService.getInstance().batchAdd(taskReelPlayerDemands);
            taskReel.setTaskReelPlayerDemands(taskReelPlayerDemands);
        }
        ItemStackUtil.addItem(player.getInventory(), TaskUtil.createTaskItemStack(taskReel, player), 1);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(taskReelId > 0 ? "succeedMsg" : "failureMsg"));
    }
}

