/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.inventory;

import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.constants.RarityEnum;
import com.handy.playertask.entity.TaskNpcPlayer;
import com.handy.playertask.hook.PlaceholderApiUtil;
import com.handy.playertask.lib.core.MapUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.service.TaskNpcPlayerService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.TaskUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OpenMeNpcTaskGui {
    private static final OpenMeNpcTaskGui INSTANCE = new OpenMeNpcTaskGui();

    private OpenMeNpcTaskGui() {
    }

    public static OpenMeNpcTaskGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.NPC_CONFIG.getString("meTitle", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.NPC_CONFIG.getInt("meSize", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.TASK_NPC.getType(), title, size);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.OPEN_ME_NPC_TASK.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Player player = handyInventory.getPlayer();
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.NPC_CONFIG.getString("npc.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TaskNpcPlayer> page = TaskNpcPlayerService.getInstance().page(player.getUniqueId(), handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<TaskNpcPlayer> taskNpcList = page.getRecords();
        int i = 0;
        String name = ConfigUtil.NPC_CONFIG.getString("npc.name", "");
        String havaMaterial = ConfigUtil.NPC_CONFIG.getString("npc.havaMaterial", "BOOK");
        String doneMaterial = ConfigUtil.NPC_CONFIG.getString("npc.doneMaterial", "ENCHANTED_BOOK");
        List scheduleLore = ConfigUtil.NPC_CONFIG.getStringList("npc.scheduleLore");
        int havaCustomModelData = ConfigUtil.NPC_CONFIG.getInt("npc.hava-custom-model-data", 0);
        int doneCustomModelData = ConfigUtil.NPC_CONFIG.getInt("npc.done-custom-model-data", 0);
        for (TaskNpcPlayer taskNpcPlayer : taskNpcList) {
            String itemName = StrUtil.replace(name, "taskName", taskNpcPlayer.getTaskName());
            boolean isEnchant = taskNpcPlayer.getStatus();
            String itemMaterial = taskNpcPlayer.getStatus() != false ? doneMaterial : havaMaterial;
            int itemCustomModelData = taskNpcPlayer.getStatus() != false ? doneCustomModelData : havaCustomModelData;
            List<String> loreList = ItemStackUtil.loreBatchReplaceMap(scheduleLore, this.getReplaceMap(taskNpcPlayer, player), "");
            ItemStack itemStack = ItemStackUtil.getItemStack(itemMaterial, itemName, loreList, isEnchant, itemCustomModelData);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, taskNpcPlayer.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.NPC_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.NPC_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.NPC_CONFIG, inventory, "custom.back");
        HandyInventoryUtil.setButton(ConfigUtil.NPC_CONFIG, inventory, "custom.pane");
    }

    private Map<String, List<String>> getReplaceMap(TaskNpcPlayer taskNpcPlayer, Player player) {
        HashMap<String, List<String>> map = MapUtil.newHashMapWithExpectedSize(5);
        map.put("taskSchedule", TaskUtil.taskScheduleLoreList(taskNpcPlayer.getTaskPlayerDemands()));
        map.put("taskReward", TaskUtil.taskRewardReplaceMap(taskNpcPlayer.getTaskRewardsList(), player));
        map.put("button", Collections.singletonList(BaseUtil.getMsgNotColor(taskNpcPlayer.getStatus() != false ? "isFinish" : "notTaskFinish")));
        map.put("rarity", Collections.singletonList(RarityEnum.getEnumName(taskNpcPlayer.getRarity())));
        map.put("description", TaskUtil.getDescription(taskNpcPlayer.getDescription()));
        return map;
    }
}

