/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.inventory;

import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.constants.RarityEnum;
import com.handy.playertask.constants.TaskTypeEnum;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.hook.PlaceholderApiUtil;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.MapUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.param.TaskDemandParam;
import com.handy.playertask.param.TaskReplaceContent;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.DemandReplaceUtil;
import com.handy.playertask.util.RewardReplaceUtil;
import com.handy.playertask.util.TaskUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ViewListGui {
    private static final ViewListGui INSTANCE = new ViewListGui();

    private ViewListGui() {
    }

    public static ViewListGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, String searchType, String raritySearchType) {
        String title = ConfigUtil.LIST_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.LIST_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_LIST.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setSearchType(searchType);
        handyInventory.setObj(raritySearchType);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_LIST.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        String searchType = handyInventory.getSearchType();
        Object obj = handyInventory.getObj();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.LIST_CONFIG.getString("list.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TaskList> page = TaskListService.getInstance().page(handyInventory.getPageNum(), handyInventory.getPageSize(), searchType, obj.toString());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        String name = ConfigUtil.LIST_CONFIG.getString("list.name", "");
        String material = ConfigUtil.LIST_CONFIG.getString("list.material", "PLAYER_HEAD");
        List listLore = ConfigUtil.LIST_CONFIG.getStringList("list.lore");
        int i = 0;
        for (TaskList taskList : page.getRecords()) {
            String displayName = StrUtil.replace(name, "id", taskList.getId().toString());
            displayName = StrUtil.replace(displayName, "taskName", taskList.getTaskName());
            List<String> loreList = ItemStackUtil.loreBatchReplaceMap(listLore, this.getReplaceMap(taskList), null);
            ItemStack itemStack = ItemStackUtil.getItemStack(material, displayName, loreList);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, taskList.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.LIST_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.LIST_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.LIST_CONFIG, inventory, "search", this.replaceSearchMap(handyInventory));
        HandyInventoryUtil.setButton(ConfigUtil.LIST_CONFIG, inventory, "raritySearch", this.replaceRaritySearchSearchMap(handyInventory));
        HandyInventoryUtil.setButton(ConfigUtil.LIST_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.LIST_CONFIG, inventory, "pane");
    }

    private Map<String, List<String>> getReplaceMap(TaskList taskList) {
        HashMap<String, List<String>> map = MapUtil.newHashMapWithExpectedSize(6);
        ArrayList<String> taskDemandLoreList = new ArrayList<String>();
        List<TaskDemand> taskDemands = taskList.getTaskDemands();
        if (CollUtil.isEmpty(taskDemands)) {
            taskDemandLoreList.add(BaseUtil.getMsgNotColor("none"));
        } else {
            for (TaskDemand taskDemand : taskDemands) {
                TaskReplaceContent demandContent = DemandReplaceUtil.getDemandContent(TaskDemandParam.init(taskDemand));
                taskDemandLoreList.add(demandContent.getMsg());
            }
        }
        map.put("taskTarget", taskDemandLoreList);
        ArrayList<String> rewardLoreList = new ArrayList<String>();
        List<TaskRewards> taskRewardsList = taskList.getTaskRewardsList();
        if (CollUtil.isEmpty(taskRewardsList)) {
            rewardLoreList.add(BaseUtil.getMsgNotColor("none"));
        } else {
            for (TaskRewards taskRewards : taskRewardsList) {
                TaskReplaceContent rewardContent = RewardReplaceUtil.getRewardContent(taskRewards, null);
                rewardLoreList.add(rewardContent.getMsg());
            }
        }
        map.put("taskReward", rewardLoreList);
        ArrayList<String> taskIdLoreList = new ArrayList<String>();
        taskIdLoreList.add(taskList.getId().toString());
        map.put("taskId", taskIdLoreList);
        map.put("taskType", Collections.singletonList(TaskTypeEnum.getTypeName(taskList.getType())));
        map.put("rarity", Collections.singletonList(RarityEnum.getEnumName(taskList.getRarity())));
        map.put("description", TaskUtil.getDescription(taskList.getDescription()));
        map.put("enableCommand", Collections.singletonList(StrUtil.isNotEmpty(taskList.getEnableCommand()) ? StrUtil.replaceSpace(taskList.getEnableCommand()) : BaseUtil.getMsgNotColor("none")));
        return map;
    }

    private Map<String, String> replaceSearchMap(HandyInventory handyInventory) {
        String searchType = handyInventory.getSearchType();
        TaskTypeEnum taskTypeEnum = TaskTypeEnum.getEnum(searchType);
        TaskTypeEnum nextEnum = TaskTypeEnum.getNextEnum(searchType);
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        map.put("type", TaskTypeEnum.getTypeName(taskTypeEnum.getType()));
        map.put("nextType", TaskTypeEnum.getTypeName(nextEnum.getType()));
        return map;
    }

    private Map<String, String> replaceRaritySearchSearchMap(HandyInventory handyInventory) {
        String searchType = handyInventory.getObj().toString();
        RarityEnum rarityEnum = RarityEnum.getEnum(searchType);
        RarityEnum nextEnum = RarityEnum.getNextEnum(searchType);
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        map.put("type", RarityEnum.getEnumName(rarityEnum.getType()));
        map.put("nextType", RarityEnum.getEnumName(nextEnum.getType()));
        return map;
    }
}

