/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.event.PlayerTaskScheduleEvent;
import com.handy.playertask.lib.annotation.HandyListener;
import com.handy.playertask.lib.util.ItemStackUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class CraftItemEventListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onCraftItem(CraftItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemStack eventItemStack = event.getInventory().getResult();
        if (eventItemStack == null || Material.AIR.equals((Object)eventItemStack.getType())) {
            return;
        }
        HumanEntity whoClicked = event.getWhoClicked();
        if (!(whoClicked instanceof Player)) {
            return;
        }
        Player player = (Player)whoClicked;
        int amount = eventItemStack.getAmount();
        eventItemStack.setAmount(1);
        String content = ItemStackUtil.itemStackSerialize(eventItemStack);
        eventItemStack.setAmount(amount);
        if (event.isShiftClick()) {
            int itemsChecked = 0;
            int possibleCreations = 1;
            int amountCanBeMade = 0;
            for (ItemStack item : event.getInventory().getMatrix()) {
                if (item == null || item.getType() == Material.AIR) continue;
                if (itemsChecked == 0) {
                    possibleCreations = item.getAmount();
                    ++itemsChecked;
                    continue;
                }
                possibleCreations = Math.min(possibleCreations, item.getAmount());
            }
            int amountOfItems = event.getRecipe().getResult().getAmount() * possibleCreations;
            ItemStack i = event.getRecipe().getResult();
            for (int s = 0; s <= 35; ++s) {
                ItemStack test = player.getInventory().getItem(s);
                if (test == null || test.getType() == Material.AIR) {
                    amountCanBeMade += i.getMaxStackSize();
                    continue;
                }
                if (!test.isSimilar(i)) continue;
                amountCanBeMade += i.getMaxStackSize() - test.getAmount();
            }
            amount = Math.min(amountOfItems, amountCanBeMade);
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerTaskScheduleEvent(player, DemandTypeEnum.CRAFT_ITEM.getType(), amount, content));
    }
}

