/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.util;

import com.handy.playertask.constants.RewardTypeEnum;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.param.TaskReplaceContent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RewardReplaceUtil {
    public static TaskReplaceContent getRewardContent(TaskRewards taskRewards, Player player) {
        ItemStack itemStack;
        RewardTypeEnum rewardTypeEnum = RewardTypeEnum.getEnumThrow(taskRewards.getType());
        String typeName = RewardTypeEnum.getTypeName(rewardTypeEnum.getType());
        String msg = "";
        String amount = taskRewards.getAmount().toString();
        switch (rewardTypeEnum) {
            case VAULT: {
                itemStack = new ItemStack(Material.GOLD_INGOT);
                msg = typeName + " " + amount;
                break;
            }
            case PLAYER_POINTS: {
                itemStack = new ItemStack(Material.DIAMOND);
                msg = typeName + " " + amount;
                break;
            }
            case COIN: {
                itemStack = new ItemStack(Material.EMERALD);
                msg = typeName + " " + amount;
                break;
            }
            case ITEM_STACK: {
                itemStack = ItemStackUtil.itemStackDeserialize(taskRewards.getItemStack(), Material.STONE);
                msg = typeName + " " + amount + " " + BaseUtil.getDisplayName(itemStack);
                break;
            }
            case COMMAND: {
                itemStack = new ItemStack(Material.NAME_TAG);
                msg = typeName + " " + taskRewards.getItemStack().replace("${player}", player != null ? player.getName() : "${player}");
                break;
            }
            default: {
                itemStack = new ItemStack(Material.STONE);
            }
        }
        if (StrUtil.isNotEmpty(taskRewards.getDescription())) {
            msg = taskRewards.getDescription();
        }
        return TaskReplaceContent.init(msg, itemStack);
    }
}

