/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.util;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.RarityEnum;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.entity.TaskNpcPlayerDemand;
import com.handy.playertask.entity.TaskPlayer;
import com.handy.playertask.entity.TaskPlayerDemand;
import com.handy.playertask.entity.TaskReel;
import com.handy.playertask.entity.TaskReelPlayerDemand;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.DateUtil;
import com.handy.playertask.lib.core.MapUtil;
import com.handy.playertask.lib.core.SignUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.param.TaskDemandParam;
import com.handy.playertask.param.TaskReplaceContent;
import com.handy.playertask.service.TaskPlayerService;
import com.handy.playertask.service.TaskRewardsService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.DemandReplaceUtil;
import com.handy.playertask.util.RewardReplaceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TaskUtil {
    public static ItemStack createTaskItemStack(TaskReel taskReel, Player player) {
        TaskPlayer taskPlayer = new TaskPlayer();
        taskPlayer.setTaskId(taskReel.getTaskId());
        taskPlayer.setPlayerName(taskReel.getPlayerName());
        taskPlayer.setPlayerUuid(taskReel.getPlayerUuid());
        taskPlayer.setTaskName(taskReel.getTaskName());
        taskPlayer.setTaskDemand(taskReel.getTaskDemand());
        taskPlayer.setTaskRewards(taskReel.getTaskRewards());
        taskPlayer.setStatus(taskReel.getStatus());
        taskPlayer.setDescription(taskReel.getDescription());
        ArrayList<TaskPlayerDemand> taskPlayerDemands = new ArrayList<TaskPlayerDemand>();
        if (CollUtil.isNotEmpty(taskReel.getTaskReelPlayerDemands())) {
            for (TaskReelPlayerDemand taskDemand : taskReel.getTaskReelPlayerDemands()) {
                TaskPlayerDemand taskPlayerDemand = new TaskPlayerDemand();
                taskPlayerDemand.setType(taskDemand.getType());
                taskPlayerDemand.setCompletionAmount(taskDemand.getCompletionAmount());
                taskPlayerDemand.setAmount(taskDemand.getAmount());
                taskPlayerDemand.setItemStack(taskDemand.getItemStack());
                taskPlayerDemands.add(taskPlayerDemand);
            }
        }
        taskPlayer.setTaskPlayerDemands(taskPlayerDemands);
        List<TaskRewards> taskRewardsList = TaskRewardsService.getInstance().findByIds(StrUtil.strToIntList(taskReel.getTaskRewards()));
        taskPlayer.setTaskRewardsList(taskRewardsList);
        taskPlayer.setRarity(taskReel.getRarity());
        List taskLore = ConfigUtil.REEL_CONFIG.getStringList("reel.lore");
        String materialStr = ConfigUtil.REEL_CONFIG.getString("reel.material", Material.PAPER.name());
        int customModelDataId = ConfigUtil.REEL_CONFIG.getInt("reel.custom-model-data", 0);
        ItemStack taskItemStack = TaskUtil.createTaskItemStack(materialStr, customModelDataId, player, taskPlayer, taskLore);
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(taskItemStack);
        itemMeta.addEnchant(Enchantment.LURE, taskReel.getPlayerReelId().intValue(), true);
        ItemStackUtil.hideEnchant(itemMeta);
        taskItemStack.setItemMeta(itemMeta);
        return taskItemStack;
    }

    public static ItemStack createTaskItemStack(Player player, TaskPlayer taskPlayer) {
        String openMaterial = ConfigUtil.OPEN_CONFIG.getString(taskPlayer.getStatus() != false ? "task.doneMaterial" : "task.material", Material.BOOK.name());
        String material = ConfigUtil.MATERIAL_CONFIG.getString(taskPlayer.getTaskId().toString(), openMaterial);
        int openCustomModelDataId = ConfigUtil.OPEN_CONFIG.getInt("task.custom-model-data", 0);
        int customModelDataId = ConfigUtil.MATERIAL_CONFIG.getInt(taskPlayer.getTaskId() + "_custom-model-data", openCustomModelDataId);
        List loreList = ConfigUtil.OPEN_CONFIG.getStringList("task.lore");
        return TaskUtil.createTaskItemStack(material, customModelDataId, player, taskPlayer, loreList);
    }

    private static ItemStack createTaskItemStack(String material, int customModelDataId, Player player, TaskPlayer taskPlayer, List<String> taskLore) {
        List<String> loreList = ItemStackUtil.loreReplaceMap(taskLore, TaskUtil.getLoreReplaceMap(taskPlayer));
        List<String> newLoreList = ItemStackUtil.loreBatchReplaceMap(loreList, TaskUtil.getLoreBatchReplaceMap(taskPlayer, player), "");
        String taskName = ConfigUtil.OPEN_CONFIG.getString("task.name", "${taskName}");
        taskName = taskName.replace("${taskName}", taskPlayer.getTaskName()).replace("${rarity}", RarityEnum.getEnumName(taskPlayer.getRarity()));
        return ItemStackUtil.getItemStack(material, taskName, newLoreList, taskPlayer.getStatus(), customModelDataId);
    }

    public static Map<String, String> getLoreReplaceMap(TaskPlayer taskPlayer) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(5);
        map.put("button", BaseUtil.getMsgNotColor(taskPlayer.getStatus() != false ? "taskFinish" : "submitFinish"));
        map.put("reelButton", StrUtil.isNotEmpty(taskPlayer.getPlayerUuid()) ? (taskPlayer.getStatus().booleanValue() ? BaseUtil.getMsgNotColor("reel.finish") : BaseUtil.getMsgNotColor("reel.noFinish")) : BaseUtil.getMsgNotColor("reel.bindrButton"));
        map.put("rarity", RarityEnum.getEnumName(taskPlayer.getRarity()));
        map.put("taskName", taskPlayer.getTaskName());
        map.put("bindPlayer", taskPlayer.getPlayerName());
        return map;
    }

    public static Map<String, List<String>> getLoreBatchReplaceMap(TaskPlayer taskPlayer, Player player) {
        HashMap<String, List<String>> map = MapUtil.newHashMapWithExpectedSize(4);
        map.put("taskTarget", TaskUtil.playerTaskTargetReplaceMap(taskPlayer.getTaskPlayerDemands()));
        map.put("taskSchedule", TaskUtil.taskScheduleReplaceMap(taskPlayer.getTaskPlayerDemands()));
        map.put("taskReward", TaskUtil.taskRewardReplaceMap(taskPlayer.getTaskRewardsList(), player));
        map.put("description", TaskUtil.getDescription(taskPlayer.getDescription()));
        return map;
    }

    public static List<String> playerTaskTargetReplaceMap(List<TaskPlayerDemand> taskPlayerDemands) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (CollUtil.isEmpty(taskPlayerDemands)) {
            loreList.add(BaseUtil.getMsgNotColor("none"));
            return loreList;
        }
        for (TaskPlayerDemand taskPlayerDemand : taskPlayerDemands) {
            TaskReplaceContent demandContent = DemandReplaceUtil.getDemandContent(TaskDemandParam.init(taskPlayerDemand));
            loreList.add(demandContent.getMsg());
        }
        return loreList;
    }

    public static List<String> taskTargetReplaceMap(List<TaskDemand> taskDemands) {
        ArrayList<String> taskDemandLoreList = new ArrayList<String>();
        if (CollUtil.isEmpty(taskDemands)) {
            taskDemandLoreList.add(BaseUtil.getMsgNotColor("none"));
        } else {
            for (TaskDemand taskDemand : taskDemands) {
                TaskReplaceContent demandContent = DemandReplaceUtil.getDemandContent(TaskDemandParam.init(taskDemand));
                taskDemandLoreList.add(demandContent.getMsg());
            }
        }
        return taskDemandLoreList;
    }

    public static List<String> taskScheduleLoreList(List<TaskNpcPlayerDemand> taskNpcPlayerDemands) {
        ArrayList<String> taskScheduleLoreList = new ArrayList<String>();
        if (CollUtil.isEmpty(taskNpcPlayerDemands)) {
            taskScheduleLoreList.add(BaseUtil.getMsgNotColor("none"));
        } else {
            for (TaskNpcPlayerDemand taskNpcPlayerDemand : taskNpcPlayerDemands) {
                TaskReplaceContent demandContent = DemandReplaceUtil.getDemandContent(TaskDemandParam.init(taskNpcPlayerDemand));
                taskScheduleLoreList.add(demandContent.getMsg());
            }
        }
        return taskScheduleLoreList;
    }

    public static List<String> taskScheduleReplaceMap(List<TaskPlayerDemand> taskPlayerDemands) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (CollUtil.isEmpty(taskPlayerDemands)) {
            loreList.add(BaseUtil.getMsgNotColor("none"));
            return loreList;
        }
        for (TaskPlayerDemand taskPlayerDemand : taskPlayerDemands) {
            TaskReplaceContent demandContent = DemandReplaceUtil.getDemandContent(TaskDemandParam.init(taskPlayerDemand));
            loreList.add(demandContent.getMsg());
        }
        return loreList;
    }

    public static List<String> taskRewardReplaceMap(List<TaskRewards> taskRewardsList, Player player) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (CollUtil.isEmpty(taskRewardsList)) {
            loreList.add(BaseUtil.getMsgNotColor("none"));
            return loreList;
        }
        for (TaskRewards taskRewards : taskRewardsList) {
            TaskReplaceContent rewardContent = RewardReplaceUtil.getRewardContent(taskRewards, player);
            loreList.add(rewardContent.getMsg());
        }
        return loreList;
    }

    public static List<String> getDescription(String description) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (StrUtil.isEmpty(description)) {
            loreList.add(BaseUtil.getMsgNotColor("none"));
            return loreList;
        }
        return StrUtil.strToStrList(description);
    }

    public static void check() {
        if (SignUtil.isGenuine()) {
            BaseTaskConstants.STOP = false;
            return;
        }
        Integer size = TaskPlayerService.getInstance().findCountDistinctPlayer(DateUtil.getToday());
        if (size > BaseTaskConstants.NUMBER) {
            BaseTaskConstants.STOP = true;
            MessageUtil.sendConsoleMessage(BaseTaskConstants.TIP);
        }
    }

    public static void sendMsg(String msg) {
        if (!ConfigUtil.CONFIG.getBoolean("log")) {
            return;
        }
        MessageUtil.sendConsoleMessage(msg);
    }
}

