/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.util;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.RewardTypeEnum;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.entity.TaskNpcPlayerDemand;
import com.handy.playertask.entity.TaskPlayerDemand;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.entity.TaskShop;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskDemandService;
import com.handy.playertask.service.TaskNpcPlayerDemandService;
import com.handy.playertask.service.TaskPlayerDemandService;
import com.handy.playertask.service.TaskRewardsService;
import com.handy.playertask.service.TaskShopService;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public class UpUtil {
    public static synchronized void up() {
        long start = System.currentTimeMillis();
        MessageUtil.sendConsoleMessage(ChatColor.GREEN + "\u521d\u59cb\u5316\u6570\u636e\u4e2d\uff01");
        UpUtil.step1();
        UpUtil.step2();
        UpUtil.step3();
        UpUtil.step4();
        UpUtil.step5();
        MessageUtil.sendConsoleMessage(ChatColor.GREEN + "\u521d\u59cb\u5316\u6570\u636e\u5b8c\u6210,\u7528\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    }

    private static void step1() {
        List<TaskDemand> taskDemands = TaskDemandService.getInstance().selectAll();
        if (CollUtil.isEmpty(taskDemands)) {
            return;
        }
        for (TaskDemand taskDemand : taskDemands) {
            if (taskDemand.getItemStack().contains("item:")) {
                ItemStack itemStack = ItemStackUtil.itemStackDeserialize(taskDemand.getItemStack());
                String itemStackStr = ItemStackUtil.itemStackSerialize(itemStack);
                TaskDemandService.getInstance().updateItemStack(itemStackStr, taskDemand.getId());
            }
            if (!DemandTypeEnum.KILL_NORMAL.getType().equalsIgnoreCase(taskDemand.getType())) continue;
            TaskDemandService.getInstance().updateItemStack(taskDemand.getItemStack().toLowerCase(), taskDemand.getId());
        }
    }

    private static void step2() {
        List<TaskPlayerDemand> taskPlayerDemands = TaskPlayerDemandService.getInstance().selectAll();
        if (CollUtil.isEmpty(taskPlayerDemands)) {
            return;
        }
        for (TaskPlayerDemand taskPlayerDemand : taskPlayerDemands) {
            if (taskPlayerDemand.getItemStack().contains("item:")) {
                ItemStack itemStack = ItemStackUtil.itemStackDeserialize(taskPlayerDemand.getItemStack());
                String itemStackStr = ItemStackUtil.itemStackSerialize(itemStack);
                TaskPlayerDemandService.getInstance().updateItemStack(itemStackStr, taskPlayerDemand.getId());
            }
            if (!DemandTypeEnum.KILL_NORMAL.getType().equalsIgnoreCase(taskPlayerDemand.getType())) continue;
            TaskPlayerDemandService.getInstance().updateItemStack(taskPlayerDemand.getItemStack().toLowerCase(), taskPlayerDemand.getId());
        }
    }

    private static void step3() {
        List<TaskRewards> taskRewards = TaskRewardsService.getInstance().selectByType(RewardTypeEnum.ITEM_STACK.getType());
        if (CollUtil.isEmpty(taskRewards)) {
            return;
        }
        for (TaskRewards taskReward : taskRewards) {
            if (StrUtil.isEmpty(taskReward.getItemStack())) {
                TaskRewardsService.getInstance().deleteById(taskReward.getId());
                MessageUtil.sendConsoleMessage("\u51fa\u73b0\u9519\u8bef\u4efb\u52a1\u5956\u52b1\u914d\u7f6e\u5df2\u81ea\u52a8\u5220\u9664,ID:" + taskReward.getId());
                continue;
            }
            if (!taskReward.getItemStack().contains("item:")) continue;
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(taskReward.getItemStack());
            String itemStackStr = ItemStackUtil.itemStackSerialize(itemStack);
            TaskRewardsService.getInstance().updateItemStack(itemStackStr, taskReward.getId());
        }
    }

    private static void step4() {
        List<TaskShop> taskShops = TaskShopService.getInstance().selectAll();
        if (CollUtil.isEmpty(taskShops)) {
            return;
        }
        for (TaskShop taskShop : taskShops) {
            if (!taskShop.getItemStack().contains("item:")) continue;
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(taskShop.getItemStack());
            String itemStackStr = ItemStackUtil.itemStackSerialize(itemStack);
            TaskShopService.getInstance().updateItemStack(itemStackStr, taskShop.getId());
        }
    }

    private static void step5() {
        List<TaskNpcPlayerDemand> taskNpcPlayerDemands = TaskNpcPlayerDemandService.getInstance().selectAll();
        if (CollUtil.isEmpty(taskNpcPlayerDemands)) {
            return;
        }
        for (TaskNpcPlayerDemand taskNpcPlayerDemand : taskNpcPlayerDemands) {
            if (taskNpcPlayerDemand.getItemStack().contains("item:")) {
                ItemStack itemStack = ItemStackUtil.itemStackDeserialize(taskNpcPlayerDemand.getItemStack());
                String itemStackStr = ItemStackUtil.itemStackSerialize(itemStack);
                TaskNpcPlayerDemandService.getInstance().updateItemStack(itemStackStr, taskNpcPlayerDemand.getId());
            }
            if (!DemandTypeEnum.KILL_NORMAL.getType().equalsIgnoreCase(taskNpcPlayerDemand.getType())) continue;
            TaskPlayerDemandService.getInstance().updateItemStack(taskNpcPlayerDemand.getItemStack().toLowerCase(), taskNpcPlayerDemand.getId());
        }
    }
}

