/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command.admin;

import com.handy.playertitle.constants.CommandChildTypeEnum;
import com.handy.playertitle.lib.command.IHandyCommandEvent;
import com.handy.playertitle.lib.util.AssertUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleCoinService;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CoinCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "coin";
    }

    @Override
    public String permission() {
        return "playerTitle.coin";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        boolean rst;
        AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer amount = AssertUtil.isNumericToInt(args[3], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        AssertUtil.notTrue(amount < 1, sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        switch (CommandChildTypeEnum.getEnum(args[1], "coin")) {
            case COIN_GIVE: {
                rst = TitleCoinService.getInstance().give(args[2], amount);
                break;
            }
            case COIN_SET: {
                rst = TitleCoinService.getInstance().set(args[2], amount);
                break;
            }
            case COIN_TAKE: {
                rst = TitleCoinService.getInstance().take(args[2], amount);
                break;
            }
            default: {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
                return;
            }
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }
}

