/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command.admin;

import com.handy.playertitle.api.PlayerTitleApi;
import com.handy.playertitle.api.param.TitleBuffParam;
import com.handy.playertitle.api.param.TitleListParam;
import com.handy.playertitle.constants.BuffTypeEnum;
import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.CommandChildTypeEnum;
import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.lib.command.IHandyCommandEvent;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.NumberUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.core.YmlUtil;
import com.handy.playertitle.lib.db.SqlUtil;
import com.handy.playertitle.lib.util.AssertUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.HandyConfigUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.param.TitleExport;
import com.handy.playertitle.service.TitleBuffService;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TitleCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "title";
    }

    @Override
    public String permission() {
        return "playerTitle.title";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        switch (CommandChildTypeEnum.getEnum(args[1], "title")) {
            case TITLE_ADD: {
                int count;
                if (!SqlUtil.isGenuine() && (count = TitleListService.getInstance().findCount()) >= 100) {
                    MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("currlimig"));
                    return;
                }
                this.add(sender, args);
                break;
            }
            case TITLE_DELETE: {
                AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                Integer deleteTitleId = NumberUtil.isNumericToInt(args[2]);
                AssertUtil.notNull(deleteTitleId, sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
                boolean deleteRst = TitleListService.getInstance().removeById(deleteTitleId);
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(deleteRst ? "succeedMsg" : "notIdFailureMsg"));
                break;
            }
            case TITLE_LIST: {
                this.list(sender);
                break;
            }
            case TITLE_IMPORT: {
                this.titleImport(sender);
                break;
            }
            case TITLE_DESCRIPTION: {
                AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                Integer descriptionTitleId = NumberUtil.isNumericToInt(args[2]);
                AssertUtil.notNull(descriptionTitleId, sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
                boolean descriptionRst = TitleListService.getInstance().updateDescription(descriptionTitleId, args[3]);
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(descriptionRst ? "succeedMsg" : "failureMsg"));
                break;
            }
            case TITLE_EXPORT: {
                this.titleExport(sender);
                break;
            }
            default: {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
            }
        }
    }

    private void add(CommandSender sender, String[] args) {
        Integer id;
        TitleList titleList = new TitleList();
        titleList.setAmount(0);
        titleList.setDay(0);
        titleList.setIsHide(false);
        AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        BuyTypeEnum buyType = BuyTypeEnum.getEnum(args[2]);
        AssertUtil.notNull((Object)buyType, sender, BaseUtil.getMsgNotColor("buyTypeFailureMsg") + " " + args[2]);
        titleList.setBuyType(buyType.getBuyType());
        String prefixBrackets = ConfigUtil.CONFIG.getString("prefixBrackets");
        String suffixBrackets = ConfigUtil.CONFIG.getString("suffixBrackets");
        titleList.setTitleName(prefixBrackets + args[3] + suffixBrackets);
        if (BuyTypeEnum.ITEM_STACK.getBuyType().equals(buyType.getBuyType())) {
            Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
            ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
            AssertUtil.notTrue(Material.AIR.equals((Object)itemInMainHand.getType()), sender, BaseUtil.getMsgNotColor("noAir"));
            titleList.setItemStack(ItemStackUtil.itemStackSerialize(itemInMainHand));
        }
        if (BuyTypeEnum.PERMISSION.getBuyType().equals(buyType.getBuyType())) {
            AssertUtil.notTrue(args.length < 5, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
            titleList.setItemStack(args[4]);
            titleList.setAmount(0);
            titleList.setDay(0);
            titleList.setIsHide(true);
            if (args.length > 5) {
                titleList.setDescription(args[5]);
            }
            id = TitleListService.getInstance().add(titleList);
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("addSucceedMsg").replace("${id}", String.valueOf(id)));
            for (Player player : Bukkit.getOnlinePlayers()) {
                TitleUtil.setPermissionTitle(player);
            }
            return;
        }
        if (args.length > 4) {
            Integer amount = NumberUtil.isNumericToInt(args[4]);
            AssertUtil.notTrue(amount == null || amount < 0, sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
            titleList.setAmount(amount);
        }
        if (args.length > 5) {
            Integer day = NumberUtil.isNumericToInt(args[5]);
            AssertUtil.notTrue(day == null || day < 0, sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
            titleList.setDay(day);
        }
        if (args.length > 6) {
            titleList.setIsHide("false".equals(args[6]));
        }
        if (args.length > 7) {
            titleList.setDescription(args[7]);
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor((id = TitleListService.getInstance().add(titleList)) > 0 ? "addSucceedMsg" : "failureMsg").replace("${id}", String.valueOf(id)));
    }

    private void titleImport(CommandSender sender) {
        ConfigUtil.loadImportConfig();
        Map values = ConfigUtil.IMPORT_CONFIG.getValues(false);
        for (String key : values.keySet()) {
            boolean enable;
            MemorySection memorySection = (MemorySection)values.get(key);
            if (memorySection == null || (enable = memorySection.getBoolean("enable"))) continue;
            String buyType = memorySection.getString("buyType");
            BuyTypeEnum buyTypeEnum = BuyTypeEnum.getEnum(buyType);
            if (buyTypeEnum == null) {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("buyTypeFailureMsg") + ": " + buyType);
                continue;
            }
            String itemStack = memorySection.getString("itemStack", "");
            if (!BuyTypeEnum.PERMISSION.equals((Object)buyTypeEnum) && StrUtil.isNotEmpty(itemStack)) {
                Material material = ItemStackUtil.getMaterial(itemStack);
                itemStack = ItemStackUtil.itemStackSerialize(new ItemStack(material));
            }
            List description = memorySection.getStringList("description");
            TitleListParam titleListParam = new TitleListParam();
            titleListParam.setTitleName(memorySection.getString("titleName"));
            titleListParam.setBuyType(buyType);
            titleListParam.setAmount(memorySection.getInt("amount", 0));
            titleListParam.setDay(memorySection.getInt("day", 0));
            titleListParam.setItemStack(itemStack);
            titleListParam.setIsHide(memorySection.getBoolean("isHide", false) ? 1 : 0);
            titleListParam.setDescription(CollUtil.isNotEmpty(description) ? CollUtil.listToStr(description) : null);
            titleListParam.setIsPrefixAndSuffix(true);
            String buffType = memorySection.getString("buffType");
            List buffList = memorySection.getStringList("buff");
            List buffDescriptionList = memorySection.getStringList("buffDescription");
            if (StrUtil.isNotEmpty(buffType) && CollUtil.isNotEmpty(buffList)) {
                BuffTypeEnum buffTypeEnum = BuffTypeEnum.getEnum(buffType);
                if (buffTypeEnum == null) {
                    MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("buffTypeFailureMsg") + ": " + buffType);
                    continue;
                }
                ArrayList<TitleBuffParam> titleBuffs = new ArrayList<TitleBuffParam>();
                for (int i2 = 0; i2 < buffList.size(); ++i2) {
                    TitleBuffParam titleBuffParam = new TitleBuffParam();
                    titleBuffParam.setBuffType(BuffTypeEnum.getEnum(buffType));
                    titleBuffParam.setBuffContent((String)buffList.get(i2));
                    if (CollUtil.isNotEmpty(buffDescriptionList) && buffDescriptionList.size() >= i2 + 1) {
                        titleBuffParam.setDescription((String)buffDescriptionList.get(i2));
                    }
                    titleBuffs.add(titleBuffParam);
                }
                titleListParam.setTitleBuffs(titleBuffs);
            }
            Long id = PlayerTitleApi.getInstance().add(titleListParam);
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("addSucceedMsg").replace("${id}", String.valueOf(id)));
        }
        for (String key : values.keySet()) {
            HandyConfigUtil.setPath(ConfigUtil.IMPORT_CONFIG, key + ".enable", true, Collections.singletonList("\u662f\u5426\u5df2\u5bfc\u5165,\u5bfc\u5165\u8fc7\u7684\u4f1a\u53d8\u4e3atrue"), "import.yml");
        }
    }

    private void list(CommandSender sender) {
        List<TitleList> titleLists = TitleListService.getInstance().findAll();
        AssertUtil.notNull(titleLists, sender, BaseUtil.getMsgNotColor("listTitle.noTitleFailureMsg"));
        MessageUtil.sendMessage(sender, ConfigUtil.LANG_CONFIG.getString("listTitle.titleList"));
        for (TitleList titleList : titleLists) {
            if (BuyTypeEnum.ITEM_STACK.getBuyType().equals(titleList.getBuyType())) {
                ItemStack itemStack = ItemStackUtil.itemStackDeserialize(titleList.getItemStack());
                String itemStackName = BaseUtil.getDisplayName(ItemStackUtil.getItemMeta(itemStack).getDisplayName(), itemStack.getType().toString());
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("listTitle.id") + titleList.getId() + "   " + BaseUtil.getMsgNotColor("listTitle.titleName") + titleList.getTitleName() + "   " + BaseUtil.getMsgNotColor("listTitle.buyType") + itemStackName + "   " + BaseUtil.getMsgNotColor("listTitle.number") + titleList.getAmount());
                continue;
            }
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("listTitle.id") + titleList.getId() + "   " + BaseUtil.getMsgNotColor("listTitle.titleName") + titleList.getTitleName() + "   " + BaseUtil.getMsgNotColor("listTitle.buyType") + BaseUtil.getMsgNotColor("buyType." + titleList.getBuyType()) + "   " + BaseUtil.getMsgNotColor("listTitle.amount") + titleList.getAmount());
        }
    }

    private void titleExport(CommandSender sender) {
        List<TitleList> titleListList = TitleListService.getInstance().findAll();
        AssertUtil.notNull(titleListList, sender, BaseUtil.getMsgNotColor("listTitle.noTitleFailureMsg"));
        List<Integer> titleIdList = titleListList.stream().map(TitleList::getId).collect(Collectors.toList());
        Map<Integer, List<TitleBuff>> buffMap = TitleBuffService.getInstance().findMapByTitleIdList(titleIdList, Arrays.asList(BuffTypeEnum.ATTRIBUTE_PLUS.getBuffType(), BuffTypeEnum.SX_ATTRIBUTE.getBuffType(), BuffTypeEnum.ATTRIBUTE_SYSTEM.getBuffType(), BuffTypeEnum.MYTHIC_LIB.getBuffType()));
        String fileName = "export.yml";
        for (TitleList titleList : titleListList) {
            TitleExport titleExport = new TitleExport();
            titleExport.setEnable(false);
            titleExport.setTitleName(titleList.getTitleName());
            titleExport.setBuyType(titleList.getBuyType());
            titleExport.setAmount(titleList.getAmount());
            titleExport.setDay(titleList.getDay());
            String itemStackStr = titleList.getItemStack();
            if (!BuyTypeEnum.PERMISSION.getBuyType().equals(titleList.getBuyType()) && StrUtil.isNotEmpty(itemStackStr)) {
                ItemStack itemStack = ItemStackUtil.itemStackDeserialize(titleList.getItemStack());
                itemStackStr = itemStack.getType().name();
            }
            titleExport.setItemStack(itemStackStr);
            titleExport.setIsHide(titleList.getIsHide());
            titleExport.setDescription(StrUtil.strToStrList(titleList.getDescription()));
            List<TitleBuff> titleBuffList = buffMap.get(titleList.getId());
            if (CollUtil.isNotEmpty(titleBuffList)) {
                titleExport.setBuffType(titleBuffList.get(0).getBuffType());
                titleExport.setBuff(titleBuffList.stream().map(TitleBuff::getBuffContent).collect(Collectors.toList()));
                titleExport.setBuffDescription(titleBuffList.stream().map(TitleBuff::getDescription).collect(Collectors.toList()));
            }
            YmlUtil.beanToYml(titleExport, fileName, titleList.getId().toString());
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("succeedMsg"));
    }
}

