/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.core.buy;

import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.core.buy.IBuyService;
import com.handy.playertitle.core.buy.impl.CoinBuyServiceImpl;
import com.handy.playertitle.core.buy.impl.ItemStackBuyServiceImpl;
import com.handy.playertitle.core.buy.impl.NotBuyServiceImpl;
import com.handy.playertitle.core.buy.impl.PlayerPointsBuyServiceImpl;
import com.handy.playertitle.core.buy.impl.VaultBuyServiceImpl;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import org.bukkit.entity.Player;

public class BuyStrategy {
    private static final BuyStrategy INSTANCE = new BuyStrategy();

    private BuyStrategy() {
    }

    public static BuyStrategy getInstance() {
        return INSTANCE;
    }

    public boolean buy(Player player, TitleList titleList) {
        IBuyService buyService;
        BuyTypeEnum buyTypeEnum = BuyTypeEnum.getEnum(titleList.getBuyType());
        if (buyTypeEnum == null) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("buyTypeFailureMsg") + " " + titleList.getBuyType());
            return false;
        }
        switch (buyTypeEnum) {
            case NOT: {
                buyService = new NotBuyServiceImpl();
                break;
            }
            case VAULT: {
                buyService = new VaultBuyServiceImpl();
                break;
            }
            case PLAYER_POINTS: {
                buyService = new PlayerPointsBuyServiceImpl();
                break;
            }
            case COIN: {
                buyService = new CoinBuyServiceImpl();
                break;
            }
            case ITEM_STACK: {
                buyService = new ItemStackBuyServiceImpl();
                break;
            }
            default: {
                return false;
            }
        }
        return buyService.buy(player, titleList);
    }
}

