/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.inventory;

import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.service.TitleBuffService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class DeleteBuffGui {
    private static final DeleteBuffGui INSTANCE = new DeleteBuffGui();

    private DeleteBuffGui() {
    }

    public static DeleteBuffGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.ADMIN_SHOP_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.ADMIN_SHOP_CONFIG.getInt("size", 54);
        title = BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, title));
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.ADMIN_SHOP_DELETE.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.ADMIN_SHOP_DELETE.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_SHOP_CONFIG, inventory, "pane");
        List<TitleBuff> titleBuffList = TitleBuffService.getInstance().findByTitleId(handyInventory.getId());
        if (CollUtil.isEmpty(titleBuffList)) {
            return;
        }
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.OPEN_CONFIG.getString("open.index"));
        String guiDelete = BaseUtil.getLangMsg("guiDelete");
        int i2 = 0;
        for (TitleBuff titleBuff : titleBuffList) {
            ArrayList<String> buff = new ArrayList<String>();
            buff.add("&aID: " + titleBuff.getId());
            buff.add(" ");
            buff.addAll(TitleUtil.getBuff(Collections.singletonList(titleBuff)));
            buff.add(" ");
            buff.add(guiDelete);
            String material = ConfigUtil.ADMIN_SHOP_CONFIG.getString("buff.material");
            ItemStack itemStack = ItemStackUtil.getItemStack(material, titleBuff.getBuffType(), buff);
            Integer index = indexList.get(i2++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, titleBuff.getId());
        }
    }
}

