/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.inventory;

import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.hook.PlayerPointsUtil;
import com.handy.playertitle.hook.VaultUtil;
import com.handy.playertitle.lib.core.MapUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class TitleCustomGui {
    private static final TitleCustomGui INSTANCE = new TitleCustomGui();

    private TitleCustomGui() {
    }

    public static TitleCustomGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, String titleName) {
        String title = ConfigUtil.TITLE_CUSTOM_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.TITLE_CUSTOM_CONFIG.getInt("size", 27);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.TITLE_CUSTOM.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setSearchType(titleName);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    private void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.TITLE_CUSTOM.getType());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        HandyInventoryUtil.setButton(ConfigUtil.TITLE_CUSTOM_CONFIG, inventory, "point", this.replaceMap(handyInventory, "point"));
        HandyInventoryUtil.setButton(ConfigUtil.TITLE_CUSTOM_CONFIG, inventory, "coin", this.replaceMap(handyInventory, "coin"));
        HandyInventoryUtil.setButton(ConfigUtil.TITLE_CUSTOM_CONFIG, inventory, "vault", this.replaceMap(handyInventory, "vault"));
        HandyInventoryUtil.setButton(ConfigUtil.TITLE_CUSTOM_CONFIG, inventory, "back");
    }

    private Map<String, String> replaceMap(HandyInventory handyInventory, String type) {
        Player player = handyInventory.getPlayer();
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(3);
        String yes = ConfigUtil.TITLE_CUSTOM_CONFIG.getString("yesButton");
        String button = ConfigUtil.TITLE_CUSTOM_CONFIG.getString("noButton");
        int price = ConfigUtil.TITLE_CUSTOM_CONFIG.getInt(type + ".price");
        int money = 0;
        if ("point".equals(type)) {
            int playerPoints;
            money = playerPoints = PlayerPointsUtil.getPlayerPoints(player);
            if (playerPoints >= price) {
                button = yes;
            }
        } else if ("vault".equals(type)) {
            double playerVault = VaultUtil.getPlayerVault(player);
            money = (int)playerVault;
            if (playerVault >= (double)price) {
                button = yes;
            }
        } else if ("coin".equals(type) && (money = Integer.parseInt(TitleUtil.getTitleCoin(player))) >= price) {
            button = yes;
        }
        map.put("price", String.valueOf(price));
        map.put("money", Integer.toString(money));
        map.put("button", button);
        map.put("title_name", handyInventory.getSearchType());
        return map;
    }
}

