/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener.gui;

import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.core.reward.RewardStrategy;
import com.handy.playertitle.entity.TitleReward;
import com.handy.playertitle.entity.TitleRewardLog;
import com.handy.playertitle.inventory.OpenGui;
import com.handy.playertitle.inventory.RewardGui;
import com.handy.playertitle.inventory.ShopGui;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.inventory.IHandyClickEvent;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.service.TitleRewardLogService;
import com.handy.playertitle.service.TitleRewardService;
import com.handy.playertitle.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class RewardClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.REWARD.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Player player = handyInventory.getPlayer();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARD_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                RewardGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARD_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                RewardGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARD_CONFIG, "shop")) {
            Inventory inventory = ShopGui.getInstance().createGui(player);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARD_CONFIG, "open")) {
            Inventory inventory = OpenGui.getInstance().createGui(player);
            handyInventory.syncOpen(inventory);
            return;
        }
        Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.OPEN_CONFIG, "custom");
        String command = custom.get(rawSlot);
        if (StrUtil.isNotEmpty(command)) {
            PlayerSchedulerUtil.syncPerformReplaceCommand(player, command);
            return;
        }
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.REWARD_CONFIG.getString("reward.index"));
        if (indexList.contains(rawSlot)) {
            Integer titleRewardId = map.get(event.getRawSlot());
            List<Object> titleRewardIds = new ArrayList();
            Optional<TitleRewardLog> titleRewardLogOptional = TitleRewardLogService.getInstance().findByPlayerName(player.getName());
            if (titleRewardLogOptional.isPresent() && StrUtil.isNotEmpty(titleRewardLogOptional.get().getRewardIds())) {
                titleRewardIds = StrUtil.strToIntList(titleRewardLogOptional.get().getRewardIds());
            }
            if (CollUtil.isNotEmpty(titleRewardIds) && titleRewardIds.contains(titleRewardId)) {
                return;
            }
            Optional<TitleReward> titleRewardOptional = TitleRewardService.getInstance().findById(titleRewardId);
            if (!titleRewardOptional.isPresent()) {
                return;
            }
            TitleReward titleReward = titleRewardOptional.get();
            int count = TitlePlayerService.getInstance().findCount(player.getName());
            if (count < titleReward.getNumber()) {
                return;
            }
            RewardStrategy.getInstance().getReward(player, titleReward);
            titleRewardIds.add(titleRewardId);
            if (titleRewardIds.size() == 1) {
                TitleRewardLog titleRewardLog = new TitleRewardLog();
                titleRewardLog.setPlayerName(player.getName());
                titleRewardLog.setPlayerUuid(player.getUniqueId().toString());
                titleRewardLog.setRewardIds(titleRewardId.toString());
                TitleRewardLogService.getInstance().add(titleRewardLog);
            } else {
                TitleRewardLogService.getInstance().updateRewardType(player.getName(), CollUtil.listToStr(titleRewardIds));
            }
            RewardGui.getInstance().setInventoryDate(handyInventory);
        }
    }
}

