/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener.gui;

import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.core.buy.BuyStrategy;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.inventory.OpenGui;
import com.handy.playertitle.inventory.ShopGui;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.inventory.IHandyClickEvent;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class ShopClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.SHOP.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Player player = handyInventory.getPlayer();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                ShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                ShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "search")) {
            String nextSearchType = BuyTypeEnum.getNextEnum(handyInventory.getSearchType());
            handyInventory.setSearchType(nextSearchType);
            ShopGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "open")) {
            Inventory inventory = OpenGui.getInstance().createGui(player);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "titleCustom")) {
            TitleConstants.TITLE_CUSTOM_MAP.put(player.getUniqueId(), "titleCustom");
            MessageUtil.sendMessage(player, ConfigUtil.TITLE_CUSTOM_CONFIG.getString("customMsg"));
            handyInventory.syncClose();
            return;
        }
        Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.SHOP_CONFIG, "custom");
        String command = custom.get(rawSlot);
        if (StrUtil.isNotEmpty(command)) {
            PlayerSchedulerUtil.syncPerformReplaceCommand(player, command);
            return;
        }
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.SHOP_CONFIG.getString("shop.index"));
        if (indexList.contains(rawSlot)) {
            Integer id = map.get(rawSlot);
            Optional<TitleList> titleListOptional = TitleListService.getInstance().findById(id);
            if (!titleListOptional.isPresent()) {
                return;
            }
            TitleList titleList = titleListOptional.get();
            if (BuyTypeEnum.ACTIVITY.getBuyType().equals(titleList.getBuyType()) || BuyTypeEnum.PERMISSION.getBuyType().equals(titleList.getBuyType())) {
                return;
            }
            boolean buy = BuyStrategy.getInstance().buy(player, titleList);
            if (buy) {
                ShopGui.getInstance().setInventoryDate(handyInventory);
            }
        }
    }
}

