/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.constants;

import java.util.ArrayList;
import java.util.List;

public enum CommandChildTypeEnum {
    BUFF_ADD_BUFF("addBuff", "buff"),
    BUFF_DELETE_BUFF("deleteBuff", "buff"),
    BUFF_EDIT_BUFF("editBuff", "buff"),
    CARD_CREATE("create", "card"),
    CARD_RANDOM("random", "card"),
    CLEAR_TITLE("title", "clear"),
    CLEAR_PLAYER("player", "clear"),
    CLEAR_BUFF("buff", "clear"),
    CLEAR_PARTICLE("particle", "clear"),
    CLEAR_REWARD("reward", "clear"),
    COIN_GIVE("give", "coin"),
    COIN_SET("set", "coin"),
    COIN_TAKE("take", "coin"),
    PARTICLE_ADD_PARTICLE("addParticle", "particle"),
    PARTICLE_DELETE_PARTICLE("deleteParticle", "particle"),
    PLAYER_ADD_TITLE("addTitle", "player"),
    PLAYER_SET_TITLE("setTitle", "player"),
    PLAYER_LIST_TITLE("listTitle", "player"),
    PLAYER_DELETE_TITLE("deleteTitle", "player"),
    PLAYER_STOP_TITLE("stopTitle", "player"),
    TITLE_ADD("add", "title"),
    TITLE_DELETE("delete", "title"),
    TITLE_LIST("list", "title"),
    TITLE_IMPORT("import", "title"),
    TITLE_DESCRIPTION("description", "title"),
    TITLE_EXPORT("export", "title"),
    VIEW_REWARD("reward", "view"),
    VIEW_SHOP("shop", "view"),
    VIEW_OPEN("open", "view"),
    NOT("not", "not");

    private final String childType;
    private final String parentType;

    public static CommandChildTypeEnum getEnum(String childType, String parentType) {
        for (CommandChildTypeEnum commandChildTypeEnum : CommandChildTypeEnum.values()) {
            if (!commandChildTypeEnum.parentType.equalsIgnoreCase(parentType) || !commandChildTypeEnum.childType.equalsIgnoreCase(childType)) continue;
            return commandChildTypeEnum;
        }
        return NOT;
    }

    public static List<String> getEnum(String parentType) {
        ArrayList<String> list = new ArrayList<String>();
        for (CommandChildTypeEnum commandChildTypeEnum : CommandChildTypeEnum.values()) {
            if (!commandChildTypeEnum.parentType.equalsIgnoreCase(parentType)) continue;
            list.add(commandChildTypeEnum.childType);
        }
        return list;
    }

    public String getChildType() {
        return this.childType;
    }

    public String getParentType() {
        return this.parentType;
    }

    private CommandChildTypeEnum(String childType, String parentType) {
        this.childType = childType;
        this.parentType = parentType;
    }
}

