/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.command.admin;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.enter.WarpChannel;
import cn.handyplus.warp.enter.WarpCollection;
import cn.handyplus.warp.enter.WarpLikePlayer;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.lib.command.IHandyCommandEvent;
import cn.handyplus.warp.lib.constants.BaseConstants;
import cn.handyplus.warp.lib.db.Db;
import cn.handyplus.warp.lib.db.SqlManagerUtil;
import cn.handyplus.warp.lib.util.AssertUtil;
import cn.handyplus.warp.lib.util.BaseUtil;
import cn.handyplus.warp.lib.util.HandyConfigUtil;
import cn.handyplus.warp.lib.util.MessageUtil;
import cn.handyplus.warp.service.WarpChannelService;
import cn.handyplus.warp.service.WarpCollectionService;
import cn.handyplus.warp.service.WarpLikePlayerService;
import cn.handyplus.warp.service.WarpPlayerService;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ConvertCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "convert";
    }

    @Override
    public String permission() {
        return "playerWarp.convert";
    }

    @Override
    public void onCommand(final CommandSender sender, Command cmd, String label, final String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getLangMsg("paramFailureMsg"));
        new BukkitRunnable(){

            public void run() {
                String storageMethod = args[1];
                if (!"MySQL".equalsIgnoreCase(storageMethod) && !"SQLite".equalsIgnoreCase(storageMethod)) {
                    sender.sendMessage(BaseUtil.getLangMsg("paramFailureMsg"));
                    return;
                }
                if (storageMethod.equalsIgnoreCase(BaseConstants.STORAGE_CONFIG.getString("storage-method"))) {
                    MessageUtil.sendMessage(sender, "&4\u7981\u6b62\u8f6c\u6362\uff01\u539f\u56e0\uff0c\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u5b58\u50a8\u65b9\u5f0f\u5df2\u7ecf\u4e3a\uff1a" + storageMethod);
                    return;
                }
                List<WarpChannel> all = WarpChannelService.getInstance().findAll();
                List<WarpCollection> all1 = WarpCollectionService.getInstance().findAll();
                List<WarpLikePlayer> all2 = WarpLikePlayerService.getInstance().findAll();
                List<WarpPlayer> all3 = WarpPlayerService.getInstance().findAll();
                HandyConfigUtil.setPath(BaseConstants.STORAGE_CONFIG, "storage-method", storageMethod, Collections.singletonList("\u5b58\u50a8\u65b9\u6cd5(MySQL,SQLite)\u8bf7\u590d\u5236\u62ec\u53f7\u5185\u7684\u7c7b\u578b,\u4e0d\u8981\u81ea\u5df1\u5199"), "storage.yml");
                SqlManagerUtil.enableSql();
                Db.use(WarpChannel.class).execution().create();
                Db.use(WarpCollection.class).execution().create();
                Db.use(WarpLikePlayer.class).execution().create();
                Db.use(WarpPlayer.class).execution().create();
                Db.use(WarpChannel.class).execution().insertBatch(all);
                Db.use(WarpCollection.class).execution().insertBatch(all1);
                Db.use(WarpLikePlayer.class).execution().insertBatch(all2);
                Db.use(WarpPlayer.class).execution().insertBatch(all3);
                MessageUtil.sendMessage(sender, "&4\u8f6c\u6362\u6570\u636e\u5b8c\u6210\uff0c\u8bf7\u52a1\u5fc5\u91cd\u542f\u670d\u52a1\u5668\uff0c\u4e0d\u7136\u6709\u53ef\u80fd\u4f1a\u51fa\u73b0\u672a\u77e5bug");
            }
        }.runTaskAsynchronously((Plugin)PlayerWarp.getInstance());
    }
}

