/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.core;

import cn.handyplus.warp.lib.core.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpUtil {
    private static final String REQUEST_TYPE_FORM = "application/x-www-form-urlencoded;charset=utf-8";
    private static final String REQUEST_TYPE_JSON = "application/json; charset=utf-8";
    private static final String CHARSET = "utf-8";
    private static final Integer CONNECT_TIMEOUT = 5000;
    private static final Integer READ_TIMEOUT = 5000;
    private static final String HTTPS = "https";

    private HttpUtil() {
    }

    public static String post(String url, String jsonContent) throws NoSuchAlgorithmException, IOException, KeyManagementException {
        return HttpUtil.doRequest("POST", url, jsonContent, REQUEST_TYPE_JSON);
    }

    public static String post(String url) throws NoSuchAlgorithmException, IOException, KeyManagementException {
        return HttpUtil.doRequest("POST", url, "", REQUEST_TYPE_FORM);
    }

    public static String post(String url, Map<String, String> params) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        return HttpUtil.doRequest("POST", url, HttpUtil.buildQuery(params), REQUEST_TYPE_FORM);
    }

    public static String get(String url) throws NoSuchAlgorithmException, IOException, KeyManagementException {
        return HttpUtil.doRequest("GET", url, "", REQUEST_TYPE_FORM);
    }

    public static String get(String url, Map<String, String> params) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        return HttpUtil.doRequest("GET", url + HttpUtil.buildQuery(params), "", REQUEST_TYPE_FORM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doRequest(String method, String url, String requestContent, String requestType) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = HttpUtil.getConnection(new URL(url), method, requestType);
            conn.setConnectTimeout(CONNECT_TIMEOUT);
            conn.setReadTimeout(READ_TIMEOUT);
            if (StrUtil.isNotEmpty(requestContent)) {
                out = conn.getOutputStream();
                out.write(requestContent.getBytes(CHARSET));
            }
            rsp = HttpUtil.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method, String requestType) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        HttpURLConnection conn;
        if (HTTPS.equals(url.getProtocol())) {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier((hostname, session) -> true);
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
        conn.setRequestProperty("Content-Type", requestType);
        return conn;
    }

    private static String getResponseAsString(HttpURLConnection conn) throws IOException {
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return HttpUtil.getStreamAsString(conn.getInputStream());
        }
        return HttpUtil.getStreamAsString(es);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, CHARSET);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String buildQuery(Map<String, String> params) throws UnsupportedEncodingException {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        query.append("?");
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, CHARSET));
        }
        return query.toString();
    }

    public static void downloadFile(String urlStr, File saveDir, String fileName) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(CONNECT_TIMEOUT);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = conn.getInputStream();
        byte[] getData = HttpUtil.readInputStream(inputStream);
        if (!saveDir.exists()) {
            saveDir.mkdir();
        }
        File file = new File(saveDir + File.separator + fileName);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(getData);
        fos.close();
        inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream bos = null;
        try {
            byte[] buffer = new byte[1024];
            int len = 0;
            bos = new ByteArrayOutputStream();
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

