/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.listener.gui;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.constants.WarpConstants;
import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.hook.VaultUtil;
import cn.handyplus.warp.inventory.AdminGui;
import cn.handyplus.warp.inventory.MeGui;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.lib.inventory.IHandyClickEvent;
import cn.handyplus.warp.lib.util.MessageUtil;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpUtil;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WarpAdminClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.ADMIN.getType();
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        final int rawSlot = event.getRawSlot();
        final Integer id = handyInventory.getId();
        final Player player = handyInventory.getPlayer();
        final OpenParam openParam = (OpenParam)handyInventory.getObj();
        new BukkitRunnable(){

            public void run() {
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_CONFIG, "back")) {
                    Inventory inventory = MeGui.getInstance().createGui(player, openParam);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_CONFIG, "delete")) {
                    WarpPlayerService.getInstance().deleteById(id);
                    Inventory inventory = MeGui.getInstance().createGui(player, openParam);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_CONFIG, "tp")) {
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> ((Player)player).closeInventory());
                    Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(id);
                    if (!warpPlayerOptional.isPresent()) {
                        return;
                    }
                    WarpUtil.runTaskTpWarpLocation(player, warpPlayerOptional.get());
                    return;
                }
                String type = null;
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_CONFIG, "location")) {
                    type = "location";
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_CONFIG, "logo")) {
                    type = "logo";
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_CONFIG, "name")) {
                    type = "name";
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_CONFIG, "description")) {
                    type = "description";
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_CONFIG, "price")) {
                    type = "price";
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_CONFIG, "type")) {
                    type = "type";
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_CONFIG, "display")) {
                    type = "display";
                }
                if (StrUtil.isEmpty(type)) {
                    return;
                }
                int price = ConfigUtil.ADMIN_CONFIG.getInt(type + ".price", 0);
                boolean rst = VaultUtil.buy(player, price);
                if (!rst) {
                    MessageUtil.sendMessage(player, ConfigUtil.ADMIN_CONFIG.getString("noButton"));
                    return;
                }
                if ("logo".equals(type)) {
                    Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(id);
                    if (!warpPlayerOptional.isPresent()) {
                        return;
                    }
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> ((Player)player).closeInventory());
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.chat("/plw setLogo " + id));
                    return;
                }
                if ("location".equals(type)) {
                    Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(id);
                    if (!warpPlayerOptional.isPresent()) {
                        return;
                    }
                    WarpPlayer warpPlayer = warpPlayerOptional.get();
                    warpPlayer.setWorldName(player.getWorld().getName());
                    warpPlayer.setServerName(ConfigUtil.CONFIG.getString("serverName"));
                    warpPlayer.setWarpLocation(WarpUtil.getWarpLocationSpawn(player));
                    WarpPlayerService.getInstance().update(warpPlayer);
                    MessageUtil.sendMessage(player, ConfigUtil.ADMIN_CONFIG.getString("okLocationButton", ""));
                    return;
                }
                if ("type".equals(type)) {
                    Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(id);
                    if (!warpPlayerOptional.isPresent()) {
                        return;
                    }
                    WarpPlayer warpPlayer = warpPlayerOptional.get();
                    String nextType = WarpTypeEnum.getNotAllNextEnum(warpPlayer.getType()).getType();
                    warpPlayer.setType(nextType);
                    WarpPlayerService.getInstance().update(warpPlayer);
                    MessageUtil.sendMessage(player, ConfigUtil.ADMIN_CONFIG.getString("okTypeButton", ""));
                    Inventory inventory = AdminGui.getInstance().createGui(player, id, openParam);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                if ("display".equals(type)) {
                    WarpPlayer warpPlayer;
                    Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(id);
                    if (!warpPlayerOptional.isPresent()) {
                        return;
                    }
                    warpPlayer.setDisplay((warpPlayer = warpPlayerOptional.get()).getDisplay() == false);
                    WarpPlayerService.getInstance().update(warpPlayer);
                    Inventory inventory = AdminGui.getInstance().createGui(player, id, openParam);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                WarpConstants.CHAT_CACHE_MAP.put(player.getUniqueId(), "chang_" + type);
                WarpConstants.CHAT_CACHE_ID_MAP.put(player.getUniqueId(), id);
                MessageUtil.sendMessage(player, ConfigUtil.ADMIN_CONFIG.getString("chang_" + type));
                Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> ((Player)player).closeInventory());
            }
        }.runTaskAsynchronously((Plugin)PlayerWarp.getInstance());
    }
}

