/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.listener.gui;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.hook.PlayerPointsUtil;
import cn.handyplus.warp.hook.VaultUtil;
import cn.handyplus.warp.inventory.OpenGui;
import cn.handyplus.warp.inventory.SelectGui;
import cn.handyplus.warp.lib.core.DateUtil;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.lib.inventory.IHandyClickEvent;
import cn.handyplus.warp.lib.util.MessageUtil;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import java.util.Date;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WarpSelectPayClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.SELECT_PAY.getType();
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        final int rawSlot = event.getRawSlot();
        final Player player = handyInventory.getPlayer();
        final Integer selectRawSlot = handyInventory.getId();
        final Integer warpId = Integer.valueOf(handyInventory.getSearchType());
        final OpenParam openParam = (OpenParam)handyInventory.getObj();
        new BukkitRunnable(){

            public void run() {
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SELECT_CONFIG, "payBack")) {
                    Inventory inventory = SelectGui.getInstance().createGui(player, openParam, selectRawSlot);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                boolean rst = false;
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SELECT_CONFIG, "point")) {
                    int pointPrice = ConfigUtil.SELECT_CONFIG.getInt("point.price");
                    rst = PlayerPointsUtil.buy(player, pointPrice);
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SELECT_CONFIG, "vault")) {
                    int vaultPrice = ConfigUtil.SELECT_CONFIG.getInt("vault.price");
                    rst = VaultUtil.buy(player, vaultPrice);
                }
                if (!rst) {
                    MessageUtil.sendMessage(player, ConfigUtil.SELECT_CONFIG.getString("noButton"));
                    return;
                }
                int time = ConfigUtil.OPEN_CONFIG.getInt("top.time", 7);
                Date topTime = DateUtil.addDate(new Date(), time);
                WarpPlayerService.getInstance().updateTop(warpId, selectRawSlot, topTime);
                Inventory inventory = OpenGui.getInstance().createGui(player, openParam);
                Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
            }
        }.runTaskAsynchronously((Plugin)PlayerWarp.getInstance());
    }
}

