/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.service;

import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.lib.core.CollUtil;
import cn.handyplus.warp.lib.core.DateUtil;
import cn.handyplus.warp.lib.core.MapUtil;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.db.Db;
import cn.handyplus.warp.lib.db.enter.Page;
import cn.handyplus.warp.lib.util.GenuineUtil;
import cn.handyplus.warp.lib.util.MessageUtil;
import cn.handyplus.warp.service.WarpCollectionService;
import cn.handyplus.warp.service.WarpLikePlayerService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class WarpPlayerService {
    private WarpPlayerService() {
    }

    public static WarpPlayerService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(WarpPlayer warpPlayer) {
        return Db.use(WarpPlayer.class).execution().insert(warpPlayer);
    }

    public void addTpNumber(Integer id, Integer number) {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.update().add(WarpPlayer::getTpNumber, WarpPlayer::getTpNumber, number);
        use.execution().updateById(id);
    }

    public void addThermalValue(Integer id, Integer number) {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.update().add(WarpPlayer::getThermalValue, WarpPlayer::getThermalValue, number);
        use.execution().updateById(id);
    }

    public void subtractThermalValue(Integer id, Integer number) {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.update().subtract(WarpPlayer::getThermalValue, WarpPlayer::getThermalValue, number);
        use.execution().updateById(id);
    }

    public void setThermalValue(Integer number) {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.update().set(WarpPlayer::getThermalValue, number);
        use.execution().update();
    }

    public void update(WarpPlayer warpPlayer) {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.update().set(StrUtil.isNotEmpty(warpPlayer.getWarpLocation()), WarpPlayer::getWarpLocation, warpPlayer.getWarpLocation()).set(StrUtil.isNotEmpty(warpPlayer.getName()), WarpPlayer::getName, warpPlayer.getName()).set(StrUtil.isNotEmpty(warpPlayer.getType()), WarpPlayer::getType, warpPlayer.getType()).set(warpPlayer.getDisplay() != null, WarpPlayer::getDisplay, warpPlayer.getDisplay()).set(StrUtil.isNotEmpty(warpPlayer.getLogoName()), WarpPlayer::getLogoName, warpPlayer.getLogoName()).set(StrUtil.isNotEmpty(warpPlayer.getDescription()), WarpPlayer::getDescription, warpPlayer.getDescription()).set(warpPlayer.getPrice() != null, WarpPlayer::getPrice, warpPlayer.getPrice()).set(warpPlayer.getThermalValue() != null, WarpPlayer::getThermalValue, warpPlayer.getThermalValue()).set(StrUtil.isNotEmpty(warpPlayer.getServerName()), WarpPlayer::getServerName, warpPlayer.getServerName());
        use.execution().updateById(warpPlayer.getId());
    }

    public Integer findCount() {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.where().ge(WarpPlayer::getExpirationTime, new Date());
        return use.execution().count();
    }

    public Integer findCountByPlayerName(String playerName) {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.where().eq(WarpPlayer::getCreator, playerName).ge(WarpPlayer::getExpirationTime, new Date());
        return use.execution().count();
    }

    public Integer findCount(String type) {
        return this.findCount(type, null);
    }

    public Integer findCount(String type, List<Integer> collectionIds) {
        return this.findCount(null, type, collectionIds, true);
    }

    public Integer findCount(String playerName, String type, List<Integer> collectionIds, Boolean display) {
        Db<WarpPlayer> db = Db.use(WarpPlayer.class);
        db.where().eq(StrUtil.isNotEmpty(playerName), WarpPlayer::getCreator, playerName).eq(display != null, WarpPlayer::getDisplay, display).eq(StrUtil.isNotEmpty(type) && !WarpTypeEnum.ALL.getType().equals(type), WarpPlayer::getType, type).in(CollUtil.isNotEmpty(collectionIds), WarpPlayer::getId, collectionIds).ge(WarpPlayer::getExpirationTime, new Date()).le(!GenuineUtil.isGenuine(), WarpPlayer::getId, 100);
        return db.execution().count();
    }

    public Page<WarpPlayer> page(Integer pageNum, Integer pageSize) {
        return this.page(null, pageNum, pageSize, null, null, true);
    }

    public Page<WarpPlayer> page(Integer pageNum, Integer pageSize, String type, List<Integer> collectionIds) {
        return this.page(null, pageNum, pageSize, type, collectionIds, true);
    }

    public Page<WarpPlayer> page(String playerName, Integer pageNum, Integer pageSize, String type, List<Integer> collectionIds, Boolean display) {
        Db<WarpPlayer> db = Db.use(WarpPlayer.class);
        db.where().eq(StrUtil.isNotEmpty(playerName), WarpPlayer::getCreator, playerName).eq(display != null, WarpPlayer::getDisplay, display).eq(StrUtil.isNotEmpty(type) && !WarpTypeEnum.ALL.getType().equals(type), WarpPlayer::getType, type).limit(pageNum, pageSize).orderByDesc(WarpPlayer::getTpNumber).le(!GenuineUtil.isGenuine(), WarpPlayer::getId, 100).ge(WarpPlayer::getExpirationTime, new Date()).in(CollUtil.isNotEmpty(collectionIds), WarpPlayer::getId, collectionIds).orderByDesc(true, WarpPlayer::getThermalValue, WarpPlayer::getTpNumber);
        return db.execution().page();
    }

    public Optional<WarpPlayer> findById(Integer id) {
        return Db.use(WarpPlayer.class).execution().selectById(id);
    }

    public List<String> listServerName() {
        List<WarpPlayer> list = Db.use(WarpPlayer.class).execution().list();
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return list.stream().map(WarpPlayer::getServerName).distinct().collect(Collectors.toList());
    }

    public List<String> listWorldName(String serverName) {
        Db<WarpPlayer> db = Db.use(WarpPlayer.class);
        db.where().eq(WarpPlayer::getServerName, serverName);
        List<WarpPlayer> list = db.execution().list();
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return list.stream().map(WarpPlayer::getWorldName).distinct().collect(Collectors.toList());
    }

    public void delete(String serverName, String worldName) {
        Db<WarpPlayer> db = Db.use(WarpPlayer.class);
        db.where().eq(StrUtil.isNotEmpty(serverName), WarpPlayer::getServerName, serverName).eq(StrUtil.isNotEmpty(worldName), WarpPlayer::getWorldName, worldName);
        List<WarpPlayer> list = db.execution().list();
        if (CollUtil.isEmpty(list)) {
            return;
        }
        List<Integer> ids = list.stream().map(WarpPlayer::getId).collect(Collectors.toList());
        Db.use(WarpPlayer.class).execution().deleteBatchIds(ids);
        WarpLikePlayerService.getInstance().deleteByWarpIds(ids);
        WarpCollectionService.getInstance().deleteByWarpIds(ids);
    }

    public void deleteById(Integer id) {
        Db.use(WarpPlayer.class).execution().deleteById(id);
        WarpLikePlayerService.getInstance().deleteByWarpIds(Collections.singletonList(id));
        WarpCollectionService.getInstance().deleteByWarpIds(Collections.singletonList(id));
    }

    public List<String> listWarpId() {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.where().ge(WarpPlayer::getExpirationTime, new Date());
        List<WarpPlayer> list = use.execution().list();
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return list.stream().map(s -> s.getId().toString()).distinct().collect(Collectors.toList());
    }

    public List<String> listWarpName() {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.where().ge(WarpPlayer::getExpirationTime, new Date());
        List<WarpPlayer> list = use.execution().list();
        if (CollUtil.isEmpty(list)) {
            return new ArrayList<String>();
        }
        return list.stream().map(WarpPlayer::getName).distinct().collect(Collectors.toList());
    }

    public List<WarpPlayer> findByName(String name) {
        Db<WarpPlayer> db = Db.use(WarpPlayer.class);
        db.where().eq(WarpPlayer::getName, name);
        return db.execution().list();
    }

    public List<WarpPlayer> findAll() {
        return Db.use(WarpPlayer.class).execution().list();
    }

    public void updateExpirationTime() {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.update().set(WarpPlayer::getExpirationTime, DateUtil.getDate(36500));
        use.where().isNull(WarpPlayer::getExpirationTime);
        use.execution().update();
    }

    public void deleteExpirationTime() {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.where().le(WarpPlayer::getExpirationTime, new Date());
        List<WarpPlayer> warpPlayerList = use.execution().list();
        MessageUtil.sendConsoleMessage("\u73a9\u5bb6\u5730\u6807\u63d2\u4ef6,\u6e05\u7406\u8fc7\u671f\u5730\u6807" + warpPlayerList.size() + "\u4e2a,\u6e05\u7406\u65f6\u95f4:" + DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        if (CollUtil.isEmpty(warpPlayerList)) {
            return;
        }
        List<Integer> ids = warpPlayerList.stream().map(WarpPlayer::getId).collect(Collectors.toList());
        Db.use(WarpPlayer.class).execution().deleteBatchIds(ids);
        WarpLikePlayerService.getInstance().deleteByWarpIds(ids);
        WarpCollectionService.getInstance().deleteByWarpIds(ids);
    }

    public Map<Integer, WarpPlayer> findByTopIndexList(List<Integer> topIndexList) {
        if (CollUtil.isEmpty(topIndexList)) {
            return MapUtil.of();
        }
        Db<WarpPlayer> db = Db.use(WarpPlayer.class);
        db.where().in(WarpPlayer::getTopIndex, topIndexList).ge(WarpPlayer::getTopTime, new Date());
        List<WarpPlayer> list = db.execution().list();
        if (CollUtil.isEmpty(list)) {
            return MapUtil.of();
        }
        return list.stream().collect(Collectors.toMap(WarpPlayer::getTopIndex, v -> v));
    }

    public void updateTop(Integer id, Integer index, Date topTime) {
        Db<WarpPlayer> use = Db.use(WarpPlayer.class);
        use.update().set(WarpPlayer::getTopIndex, index).set(WarpPlayer::getTopTime, topTime);
        use.execution().updateById(id);
    }

    private static class SingletonHolder {
        private static final WarpPlayerService INSTANCE = new WarpPlayerService();

        private SingletonHolder() {
        }
    }
}

