/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.util;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.constants.WarpConstants;
import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.enter.WarpChannel;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.hook.MultiverseCoreUtil;
import cn.handyplus.warp.hook.PlaceholderApiUtil;
import cn.handyplus.warp.hook.VaultUtil;
import cn.handyplus.warp.lib.core.CollUtil;
import cn.handyplus.warp.lib.core.DateUtil;
import cn.handyplus.warp.lib.core.JsonUtil;
import cn.handyplus.warp.lib.core.MapUtil;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.util.BaseUtil;
import cn.handyplus.warp.lib.util.BcUtil;
import cn.handyplus.warp.lib.util.GenuineUtil;
import cn.handyplus.warp.lib.util.ItemStackUtil;
import cn.handyplus.warp.lib.util.MessageUtil;
import cn.handyplus.warp.param.WarpLocationSpawn;
import cn.handyplus.warp.service.WarpChannelService;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpPermissionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WarpUtil {
    public static boolean addWarp(Player player, String name, Integer time) {
        if (!WarpUtil.check(player, name)) {
            return false;
        }
        if (!WarpUtil.isPermission(player)) {
            return false;
        }
        String defaultLogo = ConfigUtil.CONFIG.getString("defaultLogo", "APPLE");
        String logoName = ItemStackUtil.itemStackSerialize(new ItemStack(ItemStackUtil.getMaterial(defaultLogo)));
        WarpPlayer warpPlayer = new WarpPlayer();
        warpPlayer.setPlayerName(player.getName());
        warpPlayer.setPlayerUuid(player.getUniqueId().toString());
        warpPlayer.setName(name);
        warpPlayer.setType(WarpTypeEnum.ARCHITECT.getType());
        warpPlayer.setLogoId(-1);
        warpPlayer.setLogoName(logoName);
        warpPlayer.setPrice(0);
        warpPlayer.setServerName(ConfigUtil.CONFIG.getString("serverName"));
        warpPlayer.setWorldName(player.getWorld().getName());
        warpPlayer.setTpNumber(0);
        warpPlayer.setThermalValue(0);
        warpPlayer.setDisplay(ConfigUtil.CONFIG.getBoolean("display", true));
        warpPlayer.setWarpLocation(WarpUtil.getWarpLocationSpawn(player));
        warpPlayer.setCreator(player.getName());
        warpPlayer.setCreateTime(new Date());
        if (time != null && time > 0) {
            warpPlayer.setExpirationTime(DateUtil.offset(warpPlayer.getCreateTime(), 12, time));
        } else {
            warpPlayer.setExpirationTime(DateUtil.getDate(36500));
        }
        WarpPlayerService.getInstance().add(warpPlayer);
        MessageUtil.sendMessage(player, ConfigUtil.CREATE_CONFIG.getString("createSucceedMsg"));
        String createSucceedAllMsg = ConfigUtil.CREATE_CONFIG.getString("createSucceedAllMsg");
        if (StrUtil.isNotEmpty(createSucceedAllMsg)) {
            createSucceedAllMsg = createSucceedAllMsg.replace("${player}", player.getName()).replace("${name}", name);
            MessageUtil.sendAllMessage(createSucceedAllMsg);
        }
        return true;
    }

    public static boolean editName(Player player, String name) {
        if (!WarpUtil.check(player, name)) {
            return false;
        }
        Integer warpId = WarpConstants.CHAT_CACHE_ID_MAP.get(player.getUniqueId());
        if (warpId == null) {
            return true;
        }
        Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(warpId);
        if (!warpPlayerOptional.isPresent()) {
            return true;
        }
        WarpPlayer warpPlayer = warpPlayerOptional.get();
        warpPlayer.setName(name);
        WarpPlayerService.getInstance().update(warpPlayer);
        MessageUtil.sendMessage(player, ConfigUtil.ADMIN_CONFIG.getString("okNameButton", "").replace("${name}", name));
        return true;
    }

    public static boolean editDescription(Player player, String description) {
        if (!WarpUtil.checkDescription(player, description)) {
            return false;
        }
        Integer warpId = WarpConstants.CHAT_CACHE_ID_MAP.get(player.getUniqueId());
        if (warpId == null) {
            return true;
        }
        Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(warpId);
        if (!warpPlayerOptional.isPresent()) {
            return true;
        }
        WarpPlayer warpPlayer = warpPlayerOptional.get();
        warpPlayer.setDescription(description);
        WarpPlayerService.getInstance().update(warpPlayer);
        MessageUtil.sendMessage(player, ConfigUtil.ADMIN_CONFIG.getString("okDescriptionButton", ""));
        return true;
    }

    public static boolean editPrice(Player player, String name) {
        Integer warpId = WarpConstants.CHAT_CACHE_ID_MAP.get(player.getUniqueId());
        if (warpId == null) {
            return true;
        }
        Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(warpId);
        if (!warpPlayerOptional.isPresent()) {
            return true;
        }
        WarpPlayer warpPlayer = warpPlayerOptional.get();
        Integer price = BaseUtil.isNumericToInt(name);
        if (price == null || price < 0) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("amountFailureMsg"));
            return false;
        }
        int maxPrice = ConfigUtil.CONFIG.getInt("maxPrice", 0);
        if (maxPrice > 0 && price > maxPrice) {
            MessageUtil.sendMessage(player, ConfigUtil.ADMIN_CONFIG.getString("maxPriceFailureMsg", "").replace("${price}", maxPrice + ""));
            return false;
        }
        warpPlayer.setPrice(price);
        WarpPlayerService.getInstance().update(warpPlayer);
        MessageUtil.sendMessage(player, ConfigUtil.ADMIN_CONFIG.getString("okPriceButton", "").replace("${price}", price.toString()));
        return true;
    }

    public static boolean check(Player player, String name) {
        List<WarpPlayer> warpPlayerList;
        int nameLength = ConfigUtil.CREATE_CONFIG.getInt("nameLength");
        if (ChatColor.stripColor((String)name).length() > nameLength) {
            String lengthFailureMsg = ConfigUtil.CREATE_CONFIG.getString("lengthFailureMsg", "").replace("${length}", nameLength + "");
            MessageUtil.sendMessage(player, lengthFailureMsg);
            return false;
        }
        if ((name.contains("&") || name.contains("\u00a7")) && !player.hasPermission("playerWarp.create.color")) {
            String colorFailureMsg = ConfigUtil.CREATE_CONFIG.getString("colorFailureMsg", "&4\u4f60\u6ca1\u6709 &a playerWarp.create.color &4\u6743\u9650\u6765\u521b\u5efa\u5f69\u8272\u540d\u79f0\u7684\u5730\u6807");
            MessageUtil.sendMessage(player, colorFailureMsg);
            return false;
        }
        List nameBlackList = ConfigUtil.CREATE_CONFIG.getStringList("nameBlackList");
        for (String nameBlack : nameBlackList) {
            if (!name.contains(nameBlack)) continue;
            String nameBlackListFailureMsg = ConfigUtil.CREATE_CONFIG.getString("nameBlackListFailureMsg", "").replace("${name}", nameBlack);
            MessageUtil.sendMessage(player, nameBlackListFailureMsg);
            return false;
        }
        boolean nameOnly = ConfigUtil.CONFIG.getBoolean("nameOnly", true);
        if (nameOnly && CollUtil.isNotEmpty(warpPlayerList = WarpPlayerService.getInstance().findByName(name))) {
            String nameOnlyFailureMsg = ConfigUtil.CREATE_CONFIG.getString("nameOnlyFailureMsg", "").replace("${name}", name);
            MessageUtil.sendMessage(player, nameOnlyFailureMsg);
            return false;
        }
        return true;
    }

    public static boolean checkDescription(Player player, String description) {
        int descriptionLength = ConfigUtil.ADMIN_CONFIG.getInt("descriptionLength", 16);
        if (ChatColor.stripColor((String)description).length() > descriptionLength) {
            String lengthFailureMsg = ConfigUtil.ADMIN_CONFIG.getString("descriptionLengthFailureMsg", "").replace("${length}", descriptionLength + "");
            MessageUtil.sendMessage(player, lengthFailureMsg);
            return false;
        }
        List nameBlackList = ConfigUtil.CREATE_CONFIG.getStringList("nameBlackList");
        for (String nameBlack : nameBlackList) {
            if (!description.contains(nameBlack)) continue;
            String nameBlackListFailureMsg = ConfigUtil.ADMIN_CONFIG.getString("descriptionFailureMsg", "").replace("${name}", nameBlack);
            MessageUtil.sendMessage(player, nameBlackListFailureMsg);
            return false;
        }
        return true;
    }

    public static boolean checkWarpNumber(Player player) {
        List notWorldList = ConfigUtil.CONFIG.getStringList("notWorld");
        if (CollUtil.isNotEmpty(notWorldList) && notWorldList.contains(player.getWorld().getName())) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("noWorldCreate"));
            return true;
        }
        int warpNumber = WarpPermissionUtil.getWarpNumber(player);
        Integer countByPlayerName = WarpPlayerService.getInstance().findCountByPlayerName(player.getName());
        if (countByPlayerName >= warpNumber) {
            String nameBlackListFailureMsg = ConfigUtil.CREATE_CONFIG.getString("warpNumberMsg", "").replace("${number}", warpNumber + "");
            MessageUtil.sendMessage(player, nameBlackListFailureMsg);
            return true;
        }
        return false;
    }

    public static String getWarpLocationSpawn(Player player) {
        Location location = player.getLocation();
        WarpLocationSpawn warpLocationSpawn = new WarpLocationSpawn();
        warpLocationSpawn.setX(location.getX());
        warpLocationSpawn.setY(location.getY());
        warpLocationSpawn.setZ(location.getZ());
        warpLocationSpawn.setYaw(location.getYaw());
        warpLocationSpawn.setPitch(location.getPitch());
        warpLocationSpawn.setWorld(Objects.requireNonNull(location.getWorld()).getName());
        return JsonUtil.toJson(warpLocationSpawn);
    }

    public static String getLocationDesc(String spawnJson) {
        WarpLocationSpawn warpLocationSpawn = JsonUtil.toBean(spawnJson, WarpLocationSpawn.class);
        return MultiverseCoreUtil.getAlias(warpLocationSpawn.getWorld()) + "," + (int)warpLocationSpawn.getX() + "," + (int)warpLocationSpawn.getY() + "," + (int)warpLocationSpawn.getZ();
    }

    public static Map<String, List<String>> getDescriptionMap(String description) {
        return MapUtil.of("description", WarpUtil.getDescription(description));
    }

    public static List<String> getDescription(String description) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (StrUtil.isEmpty(description)) {
            loreList.add(BaseUtil.getLangMsg("not"));
            return loreList;
        }
        loreList.addAll(StrUtil.strToStrList(description));
        return loreList;
    }

    public static boolean tpCheck(Player player, WarpPlayer warpPlayer) {
        String tpPermission;
        long keepAlive;
        long waitTime = WarpPermissionUtil.getWaitTime(player);
        if (WarpConstants.WAIT_TIME.containsKey(player.getUniqueId()) && (keepAlive = (System.currentTimeMillis() - WarpConstants.WAIT_TIME.get(player.getUniqueId())) / 1000L) < waitTime) {
            String waitTimeMsg = BaseUtil.getLangMsg("waitTime").replace("${waitTime}", String.valueOf(waitTime - keepAlive));
            MessageUtil.sendMessage(player, waitTimeMsg);
            return false;
        }
        boolean permission = ConfigUtil.CONFIG.getBoolean("permission." + warpPlayer.getId());
        if (permission && !player.hasPermission(tpPermission = "playerWarp.tp." + warpPlayer.getId())) {
            String noTpPermission = BaseUtil.getLangMsg("noTpPermission").replace("${permission}", tpPermission);
            MessageUtil.sendMessage(player, noTpPermission);
            return false;
        }
        if (warpPlayer.getPrice() > 0 && !player.getName().equals(warpPlayer.getCreator())) {
            boolean rst = VaultUtil.buy(player, warpPlayer.getPrice());
            if (!rst) {
                MessageUtil.sendMessage(player, ConfigUtil.ADMIN_CONFIG.getString("noButton"));
                return false;
            }
            String tpPriceMsg = BaseUtil.getLangMsg("tpPriceMsg", "").replace("${price}", warpPlayer.getPrice().toString()).replace("${name}", warpPlayer.getName());
            MessageUtil.sendMessage(player, tpPriceMsg);
            double taxRate = ConfigUtil.CONFIG.getDouble("taxRate", 0.2);
            int taxPrice = (int)((double)warpPlayer.getPrice().intValue() * taxRate);
            int number = warpPlayer.getPrice() - taxPrice;
            VaultUtil.give(Bukkit.getPlayer((String)warpPlayer.getCreator()), number);
            String tpMePriceMsg = BaseUtil.getLangMsg("tpMePriceMsg", "").replace("${player}", player.getName()).replace("${price}", number + "").replace("${taxPrice}", taxPrice + "").replace("${name}", warpPlayer.getName());
            MessageUtil.sendMessage(warpPlayer.getCreator(), tpMePriceMsg);
        }
        return true;
    }

    public static void runTaskTp(Player player, WarpPlayer warpPlayer) {
        Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> WarpUtil.tp(player, warpPlayer));
    }

    public static void runTaskTpWarpLocation(Player player, WarpPlayer warpPlayer) {
        Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> WarpUtil.tpWarpLocation(player, warpPlayer));
    }

    public static void runTaskTpLocalWarpLocation(Player player, String warpName, String warpLocation) {
        Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> WarpUtil.tpLocalWarpLocation(player, warpName, warpLocation));
    }

    private static void tp(final Player player, final WarpPlayer warpPlayer) {
        WarpUtil.executionCommand(player, "command", warpPlayer.getName());
        long delayTime = WarpPermissionUtil.getDelayTime(player);
        if (delayTime > 0L) {
            String delayTimeMsg = BaseUtil.getLangMsg("delayTime").replace("${delayTime}", String.valueOf(delayTime));
            MessageUtil.sendMessage(player, delayTimeMsg);
        }
        WarpConstants.DELAY_TIME.put(player.getUniqueId(), false);
        new BukkitRunnable(){

            public void run() {
                if (WarpConstants.DELAY_TIME.get(player.getUniqueId()) != null && WarpConstants.DELAY_TIME.get(player.getUniqueId()).booleanValue()) {
                    this.cancel();
                    return;
                }
                WarpConstants.DELAY_TIME.remove(player.getUniqueId());
                WarpUtil.tpWarpLocation(player, warpPlayer);
                WarpConstants.WAIT_TIME.put(player.getUniqueId(), System.currentTimeMillis());
                WarpPlayerService.getInstance().addTpNumber(warpPlayer.getId(), 1);
            }
        }.runTaskLater((Plugin)PlayerWarp.getInstance(), delayTime * 20L);
    }

    private static void tpWarpLocation(Player player, WarpPlayer warpPlayer) {
        String serverName = ConfigUtil.CONFIG.getString("serverName");
        if (warpPlayer.getServerName().equalsIgnoreCase(serverName)) {
            WarpUtil.tpLocalWarpLocation(player, warpPlayer.getName(), warpPlayer.getWarpLocation());
            return;
        }
        WarpChannel warpChannel = new WarpChannel();
        warpChannel.setPlayerName(player.getName());
        warpChannel.setPlayerUuid(player.getUniqueId().toString());
        warpChannel.setWarpName(warpPlayer.getName());
        warpChannel.setServerName(warpPlayer.getServerName());
        warpChannel.setWarpLocation(warpPlayer.getWarpLocation());
        WarpChannelService.getInstance().add(warpChannel);
        BcUtil.tpConnect(player, warpPlayer.getServerName());
    }

    private static void tpLocalWarpLocation(Player player, String warpName, String warpLocation) {
        Optional<Location> locationOptional = WarpUtil.getLocation(warpLocation);
        if (!locationOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("warpErrorMsg"));
            return;
        }
        player.teleport(locationOptional.get());
        String welcomeTitle = BaseUtil.getLangMsg("welcomeTitle", "");
        welcomeTitle = welcomeTitle.replace("${player}", player.getName());
        welcomeTitle = welcomeTitle.replace("${name}", warpName);
        MessageUtil.sendTitle(player, warpName, welcomeTitle);
        WarpUtil.executionCommand(player, "tpAfterCommand", warpName);
    }

    private static void executionCommand(Player player, String child, String warpName) {
        List commandList = ConfigUtil.CONFIG.getStringList(child);
        if (CollUtil.isEmpty(commandList)) {
            return;
        }
        for (String command : commandList) {
            if (StrUtil.isEmpty(command)) continue;
            command = command.replace("${player}", player.getName());
            command = command.replace("${name}", warpName);
            String finalCommand = PlaceholderApiUtil.set(player, command);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand);
        }
    }

    private static Optional<Location> getLocation(String spawnJson) {
        WarpLocationSpawn spawn = JsonUtil.toBean(spawnJson, WarpLocationSpawn.class);
        World world = Bukkit.getWorld((String)spawn.getWorld());
        if (world == null) {
            WorldCreator worldCreator = new WorldCreator(spawn.getWorld());
            world = Bukkit.getServer().createWorld(worldCreator);
        }
        if (world == null) {
            return Optional.empty();
        }
        return Optional.of(new Location(world, spawn.getX(), spawn.getY(), spawn.getZ(), spawn.getYaw(), spawn.getPitch()));
    }

    public static boolean isPermission(Player player) {
        if (GenuineUtil.isGenuine()) {
            return true;
        }
        Integer count = WarpPlayerService.getInstance().findCount();
        if (count >= 100) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("limit"));
            return false;
        }
        return true;
    }
}

