/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.generator;

import com.plotsquared.bukkit.generator.BlockStatePopulator;
import com.plotsquared.bukkit.generator.BukkitAugmentedGenerator;
import com.plotsquared.bukkit.generator.DelegatePlotGenerator;
import com.plotsquared.bukkit.generator.LegacyBlockStatePopulator;
import com.plotsquared.bukkit.queue.GenChunk;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.bukkit.util.BukkitWorld;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.generator.SingleWorldGenerator;
import com.plotsquared.core.location.ChunkWrapper;
import com.plotsquared.core.location.UncheckedWorldLocation;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.ChunkManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.HeightMap;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitPlotGenerator
extends ChunkGenerator
implements GeneratorWrapper<ChunkGenerator> {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + BukkitPlotGenerator.class.getSimpleName()));
    public final boolean PAPER_ASYNC_SAFE = true;
    private final PlotAreaManager plotAreaManager;
    private final IndependentPlotGenerator plotGenerator;
    private final ChunkGenerator platformGenerator;
    private final boolean full;
    private final String levelName;
    private final boolean useNewGenerationMethods;
    private final BiomeProvider biomeProvider;
    private List<BlockPopulator> populators;
    private boolean loaded = false;
    private PlotArea lastPlotArea;
    private int lastChunkX = Integer.MIN_VALUE;
    private int lastChunkZ = Integer.MIN_VALUE;

    public BukkitPlotGenerator(@NonNull String name, @NonNull IndependentPlotGenerator generator, @NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
        this.levelName = name;
        this.plotGenerator = generator;
        this.platformGenerator = this;
        this.populators = new ArrayList<BlockPopulator>();
        int minecraftMinorVersion = PlotSquared.platform().serverVersion()[1];
        if (minecraftMinorVersion >= 17) {
            this.populators.add(new BlockStatePopulator(this.plotGenerator));
        } else {
            this.populators.add(new LegacyBlockStatePopulator(this.plotGenerator));
        }
        this.full = true;
        this.useNewGenerationMethods = PlotSquared.platform().serverVersion()[1] >= 19;
        this.biomeProvider = new BukkitPlotBiomeProvider();
    }

    public BukkitPlotGenerator(String world, ChunkGenerator cg, @NonNull PlotAreaManager plotAreaManager) {
        if (cg instanceof BukkitPlotGenerator) {
            throw new IllegalArgumentException("ChunkGenerator: " + cg.getClass().getName() + " is already a BukkitPlotGenerator!");
        }
        this.plotAreaManager = plotAreaManager;
        this.levelName = world;
        this.full = false;
        this.platformGenerator = cg;
        this.plotGenerator = new DelegatePlotGenerator(cg, world);
        this.useNewGenerationMethods = PlotSquared.platform().serverVersion()[1] >= 19;
        this.biomeProvider = null;
    }

    @Override
    public void augment(PlotArea area) {
        BukkitAugmentedGenerator.get(BukkitUtil.getWorld(area.getWorldName()));
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public IndependentPlotGenerator getPlotGenerator() {
        return this.plotGenerator;
    }

    @Override
    public ChunkGenerator getPlatformGenerator() {
        return this.platformGenerator;
    }

    public @NonNull List<BlockPopulator> getDefaultPopulators(@NonNull World world) {
        try {
            this.checkLoaded(world);
        }
        catch (Exception e) {
            LOGGER.error("Error attempting to load world into PlotSquared.", (Throwable)e);
        }
        ArrayList<BlockPopulator> toAdd = new ArrayList<BlockPopulator>();
        List existing = world.getPopulators();
        if (this.populators == null && this.platformGenerator != null) {
            this.populators = new ArrayList<BlockPopulator>(this.platformGenerator.getDefaultPopulators(world));
        }
        if (this.populators != null) {
            for (BlockPopulator populator : this.populators) {
                if (existing.contains(populator)) continue;
                toAdd.add(populator);
            }
        }
        return toAdd;
    }

    private synchronized void checkLoaded(@NonNull World world) {
        if (!PlotSquared.get().isWeInitialised()) {
            return;
        }
        if (!this.loaded) {
            String name = world.getName();
            PlotSquared.get().loadWorld(name, this);
            Set<PlotArea> areas = this.plotAreaManager.getPlotAreasSet(name);
            if (!areas.isEmpty()) {
                PlotArea area = areas.iterator().next();
                if (!area.isMobSpawning()) {
                    if (!area.isSpawnEggs()) {
                        world.setSpawnFlags(false, false);
                    }
                    this.setSpawnLimits(world, 0);
                } else {
                    world.setSpawnFlags(true, true);
                    this.setSpawnLimits(world, -1);
                }
            }
            this.loaded = true;
        }
    }

    private void setSpawnLimits(@NonNull World world, int limit) {
        world.setAmbientSpawnLimit(limit);
        world.setAnimalSpawnLimit(limit);
        world.setMonsterSpawnLimit(limit);
        world.setWaterAnimalSpawnLimit(limit);
    }

    public void generateNoise(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (this.platformGenerator != this) {
            this.platformGenerator.generateNoise(worldInfo, random, chunkX, chunkZ, chunkData);
            return;
        }
        int minY = chunkData.getMinHeight();
        int maxY = chunkData.getMaxHeight();
        GenChunk result = new GenChunk(minY, maxY);
        result.setChunk(new ChunkWrapper(worldInfo.getName(), chunkX, chunkZ));
        result.setChunkData(chunkData);
        result.result = null;
        try {
            this.generate(BlockVector2.at((int)chunkX, (int)chunkZ), worldInfo.getName(), result, false);
        }
        catch (Throwable e) {
            LOGGER.error("Error attempting to generate chunk.", e);
        }
    }

    public void generateSurface(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (this.platformGenerator != this) {
            this.platformGenerator.generateSurface(worldInfo, random, chunkX, chunkZ, chunkData);
        }
    }

    public void generateBedrock(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (this.platformGenerator != this) {
            this.platformGenerator.generateBedrock(worldInfo, random, chunkX, chunkZ, chunkData);
        }
    }

    public void generateCaves(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (this.platformGenerator != this) {
            this.platformGenerator.generateCaves(worldInfo, random, chunkX, chunkZ, chunkData);
        }
    }

    @Nullable
    public BiomeProvider getDefaultBiomeProvider(@NotNull WorldInfo worldInfo) {
        if (this.platformGenerator != this) {
            return this.platformGenerator.getDefaultBiomeProvider(worldInfo);
        }
        return this.biomeProvider;
    }

    public int getBaseHeight(@NotNull WorldInfo worldInfo, @NotNull Random random, int x, int z, @NotNull HeightMap heightMap) {
        PlotArea area = this.getPlotArea(worldInfo.getName(), x, z);
        if (area instanceof ClassicPlotWorld) {
            ClassicPlotWorld cpw = (ClassicPlotWorld)area;
            return cpw.PLOT_HEIGHT;
        }
        return super.getBaseHeight(worldInfo, random, x, z, heightMap);
    }

    @Deprecated(since="TODO")
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ChunkGenerator.ChunkData generateChunkData(@NonNull World world, @NonNull Random random, int x, int z, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ChunkGenerator.BiomeGrid biome) {
        if (this.useNewGenerationMethods) {
            if (this.platformGenerator != this) {
                return this.platformGenerator.generateChunkData(world, random, x, z, biome);
            }
            throw new UnsupportedOperationException("Using new generation methods. This method is unsupported.");
        }
        int minY = BukkitWorld.getMinWorldHeight(world);
        int maxY = BukkitWorld.getMaxWorldHeight(world);
        GenChunk result = new GenChunk(minY, maxY);
        if (this.getPlotGenerator() instanceof SingleWorldGenerator && result.getChunkData() != null) {
            for (int chunkX = 0; chunkX < 16; ++chunkX) {
                for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                    for (int y = minY; y < maxY; ++y) {
                        biome.setBiome(chunkX, y, chunkZ, Biome.PLAINS);
                    }
                }
            }
            return result.getChunkData();
        }
        result.setChunk(new ChunkWrapper(world.getName(), x, z));
        result.setChunkData(this.createChunkData(world));
        result.biomeGrid = biome;
        result.result = null;
        try {
            if (this.platformGenerator != this) {
                return this.platformGenerator.generateChunkData(world, random, x, z, biome);
            }
            this.generate(BlockVector2.at((int)x, (int)z), world.getName(), result, true);
        }
        catch (Throwable e) {
            LOGGER.error("Error attempting to load world into PlotSquared.", e);
        }
        return result.getChunkData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(BlockVector2 loc, String world, ZeroedDelegateScopedQueueCoordinator result, boolean biomes) {
        if (!this.loaded) {
            BukkitPlotGenerator bukkitPlotGenerator = this;
            synchronized (bukkitPlotGenerator) {
                PlotSquared.get().loadWorld(world, this);
            }
        }
        if (ChunkManager.preProcessChunk(loc, result)) {
            return;
        }
        PlotArea area = this.getPlotArea(world, loc.getX(), loc.getZ());
        try {
            this.plotGenerator.generateChunk(result, area, biomes);
        }
        catch (Throwable e) {
            LOGGER.error("Error attempting to generate chunk.", e);
        }
        ChunkManager.postProcessChunk(loc, result);
    }

    public boolean canSpawn(@NonNull World world, int x, int z) {
        return true;
    }

    public boolean shouldGenerateCaves() {
        return false;
    }

    public boolean shouldGenerateDecorations() {
        return false;
    }

    public boolean isParallelCapable() {
        return true;
    }

    public boolean shouldGenerateMobs() {
        return false;
    }

    public boolean shouldGenerateStructures() {
        return true;
    }

    @Override
    public String toString() {
        if (this.platformGenerator == this) {
            return this.plotGenerator.getName();
        }
        if (this.platformGenerator == null) {
            return "null";
        }
        return this.platformGenerator.getClass().getName();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString()) || this.toString().equals(obj.getClass().getName());
    }

    public String getLevelName() {
        return this.levelName;
    }

    private synchronized PlotArea getPlotArea(String name, int chunkX, int chunkZ) {
        if (!this.loaded) {
            PlotSquared.get().loadWorld(name, this);
        }
        if (this.lastPlotArea != null && name.equals(this.levelName) && chunkX == this.lastChunkX && chunkZ == this.lastChunkZ) {
            return this.lastPlotArea;
        }
        PlotArea area = UncheckedWorldLocation.at(name, chunkX << 4, 0, chunkZ << 4).getPlotArea();
        if (area == null) {
            throw new IllegalStateException(String.format("Cannot generate chunk that does not belong to a plot area. World: %s", name));
        }
        this.lastChunkX = chunkX;
        this.lastChunkZ = chunkZ;
        this.lastPlotArea = area;
        return this.lastPlotArea;
    }

    private final class BukkitPlotBiomeProvider
    extends BiomeProvider {
        private static final List<Biome> BIOMES;

        private BukkitPlotBiomeProvider() {
        }

        @NotNull
        public Biome getBiome(@NotNull WorldInfo worldInfo, int x, int y, int z) {
            PlotArea area = BukkitPlotGenerator.this.getPlotArea(worldInfo.getName(), x >> 4, z >> 4);
            return BukkitAdapter.adapt((BiomeType)BukkitPlotGenerator.this.plotGenerator.getBiome(area, x, y, z));
        }

        @NotNull
        public List<Biome> getBiomes(@NotNull WorldInfo worldInfo) {
            return BIOMES;
        }

        static {
            ArrayList<Biome> biomes = new ArrayList<Biome>(List.of(Biome.values()));
            biomes.remove(Biome.CUSTOM);
            BIOMES = List.copyOf(biomes);
        }
    }
}

