/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.generator;

import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.MathMan;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.util.Random;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.checkerframework.checker.nullness.qual.NonNull;

final class DelegatePlotGenerator
extends IndependentPlotGenerator {
    private final ChunkGenerator chunkGenerator;
    private final String world;

    public DelegatePlotGenerator(ChunkGenerator chunkGenerator, String world) {
        this.chunkGenerator = chunkGenerator;
        this.world = world;
    }

    @Override
    public void initialize(PlotArea area) {
    }

    @Override
    public BiomeType getBiome(PlotArea settings, int x, int y, int z) {
        return null;
    }

    @Override
    public String getName() {
        return this.chunkGenerator.getClass().getName();
    }

    @Override
    public PlotArea getNewPlotArea(String world, String id, PlotId min, PlotId max) {
        return PlotSquared.platform().defaultGenerator().getNewPlotArea(world, id, min, max);
    }

    @Override
    public void generateChunk(final ZeroedDelegateScopedQueueCoordinator result, PlotArea settings, boolean biomes) {
        World world = BukkitUtil.getWorld(this.world);
        Location min = result.getMin();
        int chunkX = min.getX() >> 4;
        int chunkZ = min.getZ() >> 4;
        Random random = new Random(MathMan.pair((short)chunkX, (short)chunkZ));
        try {
            ChunkGenerator.BiomeGrid grid = new ChunkGenerator.BiomeGrid(){

                public void setBiome(int x, int z, @NonNull Biome biome) {
                    result.setBiome(x, z, BukkitAdapter.adapt((Biome)biome));
                }

                public void setBiome(int x, int y, int z, @NonNull Biome biome) {
                    result.setBiome(x, z, BukkitAdapter.adapt((Biome)biome));
                }

                public @NonNull Biome getBiome(int x, int z) {
                    return Biome.FOREST;
                }

                public @NonNull Biome getBiome(int x, int y, int z) {
                    return Biome.FOREST;
                }
            };
            this.chunkGenerator.generateChunkData(world, random, chunkX, chunkZ, grid);
            return;
        }
        catch (Throwable throwable) {
            for (BlockPopulator populator : this.chunkGenerator.getDefaultPopulators(world)) {
                populator.populate(world, random, world.getChunkAt(chunkX, chunkZ));
            }
            return;
        }
    }
}

