/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.listener;

import com.plotsquared.bukkit.generator.BukkitPlotGenerator;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.google.Inject;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.generator.ChunkGenerator;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WorldEvents
implements Listener {
    private final PlotAreaManager plotAreaManager;

    @Inject
    public WorldEvents(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onWorldInit(WorldInitEvent event) {
        SinglePlotAreaManager single;
        World world = event.getWorld();
        String name = world.getName();
        PlotAreaManager plotAreaManager = this.plotAreaManager;
        if (plotAreaManager instanceof SinglePlotAreaManager && (single = (SinglePlotAreaManager)plotAreaManager).isWorld(name)) {
            world.setKeepSpawnInMemory(false);
            return;
        }
        ChunkGenerator gen = world.getGenerator();
        if (gen instanceof GeneratorWrapper) {
            PlotSquared.get().loadWorld(name, (GeneratorWrapper)gen);
        } else {
            PlotSquared.get().loadWorld(name, new BukkitPlotGenerator(name, gen, this.plotAreaManager));
        }
    }
}

