/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util.fawe;

import com.fastasyncworldedit.bukkit.regions.plotsquared.FaweDelegateRegionManager;
import com.plotsquared.bukkit.util.BukkitRegionManager;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.HybridPlotManager;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FaweRegionManager
extends BukkitRegionManager {
    private final FaweDelegateRegionManager delegate = new FaweDelegateRegionManager();

    @Inject
    public FaweRegionManager(WorldUtil worldUtil, GlobalBlockQueue blockQueue, ProgressSubscriberFactory subscriberFactory) {
        super(worldUtil, blockQueue, subscriberFactory);
    }

    @Override
    public boolean setCuboids(@NonNull PlotArea area, @NonNull Set<CuboidRegion> regions, @NonNull Pattern blocks, int minY, int maxY, @Nullable PlotPlayer<?> actor, @Nullable QueueCoordinator queue) {
        return this.delegate.setCuboids(area, regions, blocks, minY, maxY, queue.getCompleteTask());
    }

    @Override
    public boolean notifyClear(PlotManager manager) {
        if (!Settings.FAWE_Components.CLEAR || !(manager instanceof HybridPlotManager)) {
            return false;
        }
        return this.delegate.notifyClear(manager);
    }

    @Override
    public boolean handleClear(@NonNull Plot plot, @Nullable Runnable whenDone, @NonNull PlotManager manager, @Nullable PlotPlayer<?> player) {
        if (!Settings.FAWE_Components.CLEAR || !(manager instanceof HybridPlotManager)) {
            return false;
        }
        return this.delegate.handleClear(plot, whenDone, manager);
    }

    @Override
    public void swap(Location pos1, Location pos2, Location swapPos, @Nullable PlotPlayer<?> player, Runnable whenDone) {
        this.delegate.swap(pos1, pos2, swapPos, whenDone);
    }

    @Override
    public void setBiome(CuboidRegion region, int extendBiome, BiomeType biome, PlotArea area, Runnable whenDone) {
        this.delegate.setBiome(region, extendBiome, biome, area.getWorldName(), whenDone);
    }

    @Override
    public boolean copyRegion(@NonNull Location pos1, @NonNull Location pos2, @NonNull Location pos3, @Nullable PlotPlayer<?> player, @NonNull Runnable whenDone) {
        return this.delegate.copyRegion(pos1, pos2, pos3, whenDone);
    }

    @Override
    public boolean regenerateRegion(Location pos1, Location pos2, boolean ignore, Runnable whenDone) {
        return this.delegate.regenerateRegion(pos1, pos2, ignore, whenDone);
    }
}

