/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.uuid;

import com.google.common.base.Charsets;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class OfflinePlayerUUIDService
implements UUIDService {
    @Override
    public @NonNull List<UUIDMapping> getNames(@NonNull List<UUID> uuids) {
        if (Settings.UUID.FORCE_LOWERCASE || Bukkit.getWorlds().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UUIDMapping> wrappers = new ArrayList<UUIDMapping>(uuids.size());
        for (UUID uuid : uuids) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            try {
                if (!offlinePlayer.hasPlayedBefore()) continue;
                wrappers.add(new UUIDMapping(uuid, offlinePlayer.getName()));
            }
            catch (Exception exception) {}
        }
        return wrappers;
    }

    @Override
    public @NonNull List<UUIDMapping> getUUIDs(@NonNull List<String> usernames) {
        ArrayList<UUIDMapping> wrappers = new ArrayList<UUIDMapping>(usernames.size());
        for (String username : usernames) {
            if (Settings.UUID.OFFLINE) {
                if (Settings.UUID.FORCE_LOWERCASE) {
                    wrappers.add(new UUIDMapping(UUID.nameUUIDFromBytes(("OfflinePlayer:" + username.toLowerCase()).getBytes(Charsets.UTF_8)), username));
                    continue;
                }
                wrappers.add(new UUIDMapping(UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(Charsets.UTF_8)), username));
                continue;
            }
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)username);
            if (!offlinePlayer.hasPlayedBefore()) continue;
            wrappers.add(new UUIDMapping(offlinePlayer.getUniqueId(), offlinePlayer.getName()));
        }
        return wrappers;
    }
}

