/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SetCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.StringMan;
import com.sk89q.worldedit.command.util.SuggestionHelper;
import com.sk89q.worldedit.registry.NamespacedRegistry;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;

@CommandDeclaration(command="setbiome", permission="plots.set.biome", usage="/plot biome [biome]", aliases={"biome", "sb", "setb", "b"}, category=CommandCategory.APPEARANCE, requiredType=RequiredType.NONE)
public class Biome
extends SetCommand {
    @Override
    public boolean set(PlotPlayer<?> player, Plot plot, String value) {
        BiomeType biome = null;
        try {
            biome = BiomeTypes.get((String)value.toLowerCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (biome == null) {
            String separator = TranslatableCaption.of("blocklist.block_list_separator").getComponent(player);
            player.sendMessage(TranslatableCaption.of("biome.need_biome"), new TagResolver[0]);
            player.sendMessage(StaticCaption.of(TranslatableCaption.of("commandconfig.subcommand_set_options_header_only").getComponent(player) + StringMan.join(BiomeType.REGISTRY.values(), separator)), new TagResolver[0]);
            return false;
        }
        if (plot.getRunning() > 0) {
            player.sendMessage(TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new TagResolver[0]);
            return false;
        }
        plot.addRunning();
        plot.getPlotModificationManager().setBiome(biome, () -> {
            plot.removeRunning();
            player.sendMessage(TranslatableCaption.of("biome.biome_set_to"), TagResolver.resolver("value", Tag.inserting(Component.text(value.toLowerCase()))));
        });
        return true;
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        return SuggestionHelper.getNamespacedRegistrySuggestions((NamespacedRegistry)BiomeType.REGISTRY, (String)args[0]).map(value -> value.toLowerCase(Locale.ENGLISH).replace("minecraft:", "")).filter(value -> value.startsWith(args[0].toLowerCase(Locale.ENGLISH))).map(value -> new Command(null, false, (String)value, "", RequiredType.NONE, null){}).collect(Collectors.toList());
    }
}

