/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.Like;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.TabCompletions;
import com.plotsquared.google.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="dislike", permission="plots.dislike", usage="/plot dislike [next|purge]", category=CommandCategory.INFO, requiredType=RequiredType.PLAYER)
public class Dislike
extends SubCommand {
    private final Like like;

    @Inject
    public Dislike(@NonNull Like like) {
        this.like = like;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        return this.like.handleLike(player, args, false);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        if (args.length == 1) {
            LinkedList<String> completions = new LinkedList<String>();
            if (player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_PURGE_RATINGS)) {
                completions.add("purge");
            }
            List commands = completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[0].toLowerCase())).map(completion -> new Command(null, true, (String)completion, "", RequiredType.PLAYER, CommandCategory.INFO){}).collect(Collectors.toCollection(LinkedList::new));
            if (player.hasPermission(Permission.PERMISSION_RATE) && args[0].length() > 0) {
                commands.addAll(TabCompletions.completePlayers(player, args[0], Collections.emptyList()));
            }
            return commands;
        }
        return TabCompletions.completePlayers(player, String.join((CharSequence)",", args).trim(), Collections.emptyList());
    }
}

