/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotDoneEvent;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.google.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="done", aliases={"submit"}, permission="plots.done", category=CommandCategory.SETTINGS, requiredType=RequiredType.NONE)
public class Done
extends SubCommand {
    private final EventDispatcher eventDispatcher;
    private final HybridUtils hybridUtils;

    @Inject
    public Done(@NonNull EventDispatcher eventDispatcher, @NonNull HybridUtils hybridUtils) {
        this.eventDispatcher = eventDispatcher;
        this.hybridUtils = hybridUtils;
    }

    @Override
    public boolean onCommand(final PlotPlayer<?> player, String[] args) {
        boolean force;
        Location location = player.getLocation();
        final Plot plot = location.getPlotAbs();
        if (plot == null || !plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new TagResolver[0]);
            return false;
        }
        PlotDoneEvent event = this.eventDispatcher.callDone(plot);
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage(TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Done"))));
            return true;
        }
        boolean bl = force = event.getEventResult() == Result.FORCE;
        if (!(force || plot.isOwner(player.getUUID()) || player.hasPermission(Permission.PERMISSION_ADMIN_COMMAND_DONE))) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new TagResolver[0]);
            return false;
        }
        if (DoneFlag.isDone(plot)) {
            player.sendMessage(TranslatableCaption.of("done.done_already_done"), new TagResolver[0]);
            return false;
        }
        if (plot.getRunning() > 0) {
            player.sendMessage(TranslatableCaption.of("errors.wait_for_timer"), new TagResolver[0]);
            return false;
        }
        plot.addRunning();
        player.sendMessage(TranslatableCaption.of("web.generating_link"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.getId().toString()))));
        final Settings.Auto_Clear doneRequirements = Settings.AUTO_CLEAR.get("done");
        if (PlotSquared.platform().expireManager() == null || doneRequirements == null) {
            this.finish(plot, player, true);
            plot.removeRunning();
        } else {
            this.hybridUtils.analyzePlot(plot, new RunnableVal<PlotAnalysis>(){

                @Override
                public void run(PlotAnalysis value) {
                    plot.removeRunning();
                    boolean result = value.getComplexity(doneRequirements) <= doneRequirements.THRESHOLD;
                    Done.this.finish(plot, player, result);
                }
            });
        }
        return true;
    }

    private void finish(Plot plot, PlotPlayer<?> player, boolean success) {
        if (!success) {
            player.sendMessage(TranslatableCaption.of("done.done_insufficient_complexity"), new TagResolver[0]);
            return;
        }
        long flagValue = System.currentTimeMillis() / 1000L;
        Object plotFlag = plot.getFlagContainer().getFlag(DoneFlag.class).createFlagInstance(Long.toString(flagValue));
        PlotFlagAddEvent event = this.eventDispatcher.callFlagAdd((PlotFlag<?, ?>)plotFlag, plot);
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage(TranslatableCaption.of("events.event_denied"), new TagResolver[0]);
            return;
        }
        plot.setFlag(plotFlag);
        player.sendMessage(TranslatableCaption.of("done.done_success"), new TagResolver[0]);
    }
}

