/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.google.common.base.Preconditions;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.inject.factory.HybridPlotWorldFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.world.NullWorld;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.EnumSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HybridGen
extends IndependentPlotGenerator {
    private static final CuboidRegion CHUNK = new CuboidRegion(BlockVector3.ZERO, BlockVector3.at((int)15, (int)396, (int)15));
    private final HybridPlotWorldFactory hybridPlotWorldFactory;

    @Inject
    public HybridGen(@NonNull HybridPlotWorldFactory hybridPlotWorldFactory) {
        this.hybridPlotWorldFactory = hybridPlotWorldFactory;
    }

    @Override
    public String getName() {
        return PlotSquared.platform().pluginName();
    }

    private void placeSchem(HybridPlotWorld world, ZeroedDelegateScopedQueueCoordinator result, short relativeX, short relativeZ, int x, int z, EnumSet<SchematicFeature> features) {
        int minY = features.contains((Object)SchematicFeature.ROAD) && Settings.Schematics.PASTE_ROAD_ON_TOP || !features.contains((Object)SchematicFeature.ROAD) && Settings.Schematics.PASTE_ON_TOP ? world.SCHEM_Y : world.getMinBuildHeight();
        BaseBlock[] blocks = world.G_SCH.get(MathMan.pair(relativeX, relativeZ));
        if (blocks != null) {
            for (int y = 0; y < blocks.length; ++y) {
                if (blocks[y] == null || features.contains((Object)SchematicFeature.POPULATING) && !blocks[y].hasNbtData()) continue;
                result.setBlock(x, minY + y, z, blocks[y]);
            }
        }
        if (!features.contains((Object)SchematicFeature.BIOMES)) {
            return;
        }
        BiomeType biome = world.G_SCH_B.get(MathMan.pair(relativeX, relativeZ));
        if (biome != null) {
            result.setBiome(x, z, biome);
        }
    }

    @Override
    public void generateChunk(@NonNull ZeroedDelegateScopedQueueCoordinator result, @NonNull PlotArea settings, boolean biomes) {
        Preconditions.checkNotNull((Object)result, (Object)"result cannot be null");
        Preconditions.checkNotNull((Object)settings, (Object)"settings cannot be null");
        HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)settings;
        if (biomes) {
            result.fillBiome(hybridPlotWorld.getPlotBiome());
        }
        if (hybridPlotWorld.PLOT_BEDROCK) {
            for (int x = 0; x < 16; x = (int)((short)(x + 1))) {
                for (int z = 0; z < 16; z = (int)((short)(z + 1))) {
                    result.setBlock(x, hybridPlotWorld.getMinGenHeight(), z, BlockTypes.BEDROCK.getDefaultState());
                }
            }
        }
        EnumSet<SchematicFeature> roadFeatures = EnumSet.of(SchematicFeature.ROAD);
        EnumSet<SchematicFeature> plotFeatures = EnumSet.noneOf(SchematicFeature.class);
        if (biomes) {
            roadFeatures.add(SchematicFeature.BIOMES);
            plotFeatures.add(SchematicFeature.BIOMES);
        }
        Location min = result.getMin();
        int bx = min.getX() - hybridPlotWorld.ROAD_OFFSET_X;
        int bz = min.getZ() - hybridPlotWorld.ROAD_OFFSET_Z;
        short relativeOffsetX = (short)Math.floorMod(bx, (int)hybridPlotWorld.SIZE);
        short relativeOffsetZ = (short)Math.floorMod(bz, (int)hybridPlotWorld.SIZE);
        short[] relativeX = new short[16];
        boolean[] insideRoadX = new boolean[16];
        boolean[] insideWallX = new boolean[16];
        short offsetX = relativeOffsetX;
        for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
            if (offsetX >= hybridPlotWorld.SIZE) {
                offsetX = (short)(offsetX - hybridPlotWorld.SIZE);
            }
            relativeX[i] = offsetX;
            if (hybridPlotWorld.ROAD_WIDTH != 0) {
                insideRoadX[i] = offsetX < hybridPlotWorld.PATH_WIDTH_LOWER || offsetX > hybridPlotWorld.PATH_WIDTH_UPPER;
                insideWallX[i] = offsetX == hybridPlotWorld.PATH_WIDTH_LOWER || offsetX == hybridPlotWorld.PATH_WIDTH_UPPER;
            }
            offsetX = (short)(offsetX + 1);
        }
        short[] relativeZ = new short[16];
        boolean[] insideRoadZ = new boolean[16];
        boolean[] insideWallZ = new boolean[16];
        short offsetZ = relativeOffsetZ;
        for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
            if (offsetZ >= hybridPlotWorld.SIZE) {
                offsetZ = (short)(offsetZ - hybridPlotWorld.SIZE);
            }
            relativeZ[i] = offsetZ;
            if (hybridPlotWorld.ROAD_WIDTH != 0) {
                insideRoadZ[i] = offsetZ < hybridPlotWorld.PATH_WIDTH_LOWER || offsetZ > hybridPlotWorld.PATH_WIDTH_UPPER;
                insideWallZ[i] = offsetZ == hybridPlotWorld.PATH_WIDTH_LOWER || offsetZ == hybridPlotWorld.PATH_WIDTH_UPPER;
            }
            offsetZ = (short)(offsetZ + 1);
        }
        int startY = hybridPlotWorld.getMinGenHeight() + (hybridPlotWorld.PLOT_BEDROCK ? 1 : 0);
        for (int x = 0; x < 16; x = (int)((short)(x + 1))) {
            int y;
            int z;
            if (insideRoadX[x]) {
                for (z = 0; z < 16; z = (int)((short)(z + 1))) {
                    for (y = startY; y <= hybridPlotWorld.ROAD_HEIGHT; ++y) {
                        result.setBlock(x, y, z, hybridPlotWorld.ROAD_BLOCK.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                    this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, roadFeatures);
                }
                continue;
            }
            if (insideWallX[x]) {
                for (z = 0; z < 16; z = (int)((short)(z + 1))) {
                    if (insideRoadZ[z]) {
                        for (y = startY; y <= hybridPlotWorld.ROAD_HEIGHT; ++y) {
                            result.setBlock(x, y, z, hybridPlotWorld.ROAD_BLOCK.toPattern());
                        }
                        if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                        this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, roadFeatures);
                        continue;
                    }
                    for (y = startY; y <= hybridPlotWorld.WALL_HEIGHT; ++y) {
                        result.setBlock(x, y, z, hybridPlotWorld.WALL_FILLING.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
                        if (!hybridPlotWorld.PLACE_TOP_BLOCK) continue;
                        result.setBlock(x, hybridPlotWorld.WALL_HEIGHT + 1, z, hybridPlotWorld.WALL_BLOCK.toPattern());
                        continue;
                    }
                    this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, roadFeatures);
                }
                continue;
            }
            for (z = 0; z < 16; z = (int)((short)(z + 1))) {
                if (insideRoadZ[z]) {
                    for (y = startY; y <= hybridPlotWorld.ROAD_HEIGHT; ++y) {
                        result.setBlock(x, y, z, hybridPlotWorld.ROAD_BLOCK.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                    this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, roadFeatures);
                    continue;
                }
                if (insideWallZ[z]) {
                    for (y = startY; y <= hybridPlotWorld.WALL_HEIGHT; ++y) {
                        result.setBlock(x, y, z, hybridPlotWorld.WALL_FILLING.toPattern());
                    }
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
                        if (!hybridPlotWorld.PLACE_TOP_BLOCK) continue;
                        result.setBlock(x, hybridPlotWorld.WALL_HEIGHT + 1, z, hybridPlotWorld.WALL_BLOCK.toPattern());
                        continue;
                    }
                    this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, roadFeatures);
                    continue;
                }
                for (y = startY; y < hybridPlotWorld.PLOT_HEIGHT; ++y) {
                    result.setBlock(x, y, z, hybridPlotWorld.MAIN_BLOCK.toPattern());
                }
                result.setBlock(x, hybridPlotWorld.PLOT_HEIGHT, z, hybridPlotWorld.TOP_BLOCK.toPattern());
                if (!hybridPlotWorld.PLOT_SCHEMATIC) continue;
                this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, plotFeatures);
            }
        }
    }

    @Override
    public void populateChunk(ZeroedDelegateScopedQueueCoordinator result, PlotArea settings) {
        HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)settings;
        if (!hybridPlotWorld.populationNeeded()) {
            return;
        }
        EnumSet<SchematicFeature> roadFeatures = EnumSet.of(SchematicFeature.POPULATING, SchematicFeature.ROAD);
        EnumSet<SchematicFeature> plotFeatures = EnumSet.of(SchematicFeature.POPULATING);
        Location min = result.getMin();
        int bx = min.getX() - hybridPlotWorld.ROAD_OFFSET_X;
        int bz = min.getZ() - hybridPlotWorld.ROAD_OFFSET_Z;
        short relativeOffsetX = (short)Math.floorMod(bx, (int)hybridPlotWorld.SIZE);
        short relativeOffsetZ = (short)Math.floorMod(bz, (int)hybridPlotWorld.SIZE);
        boolean allRoad = true;
        boolean overlap = false;
        short[] relativeX = new short[16];
        boolean[] insideRoadX = new boolean[16];
        boolean[] insideWallX = new boolean[16];
        short offsetX = relativeOffsetX;
        for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
            if (offsetX >= hybridPlotWorld.SIZE) {
                offsetX = (short)(offsetX - hybridPlotWorld.SIZE);
                overlap = true;
            }
            relativeX[i] = offsetX;
            if (hybridPlotWorld.ROAD_WIDTH != 0) {
                boolean insideRoad = offsetX < hybridPlotWorld.PATH_WIDTH_LOWER || offsetX > hybridPlotWorld.PATH_WIDTH_UPPER;
                boolean insideWall = offsetX == hybridPlotWorld.PATH_WIDTH_LOWER || offsetX == hybridPlotWorld.PATH_WIDTH_UPPER;
                insideRoadX[i] = insideRoad;
                insideWallX[i] = insideWall;
                allRoad &= insideRoad && insideWall;
            }
            offsetX = (short)(offsetX + 1);
        }
        short[] relativeZ = new short[16];
        boolean[] insideRoadZ = new boolean[16];
        boolean[] insideWallZ = new boolean[16];
        short offsetZ = relativeOffsetZ;
        for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
            if (offsetZ >= hybridPlotWorld.SIZE) {
                offsetZ = (short)(offsetZ - hybridPlotWorld.SIZE);
                overlap = true;
            }
            relativeZ[i] = offsetZ;
            if (hybridPlotWorld.ROAD_WIDTH != 0) {
                boolean insideRoad = offsetZ < hybridPlotWorld.PATH_WIDTH_LOWER || offsetZ > hybridPlotWorld.PATH_WIDTH_UPPER;
                boolean insideWall = offsetZ == hybridPlotWorld.PATH_WIDTH_LOWER || offsetZ == hybridPlotWorld.PATH_WIDTH_UPPER;
                insideRoadZ[i] = insideRoad;
                insideWallZ[i] = insideWall;
                allRoad &= insideRoad && insideWall;
            }
            offsetZ = (short)(offsetZ + 1);
        }
        for (int x = 0; x < 16; x = (int)((short)(x + 1))) {
            int z;
            if (insideRoadX[x] || insideWallX[x]) {
                if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                for (z = 0; z < 16; z = (int)((short)(z + 1))) {
                    this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, roadFeatures);
                }
                continue;
            }
            for (z = 0; z < 16; z = (int)((short)(z + 1))) {
                if (insideRoadZ[z] || insideWallZ[z]) {
                    if (!hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) continue;
                    this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, roadFeatures);
                    continue;
                }
                if (!hybridPlotWorld.PLOT_SCHEMATIC) continue;
                this.placeSchem(hybridPlotWorld, result, relativeX[x], relativeZ[z], x, z, plotFeatures);
            }
        }
        if (!allRoad && hybridPlotWorld.getPlotSchematicEntities() != null && !hybridPlotWorld.getPlotSchematicEntities().isEmpty()) {
            CuboidRegion region = CHUNK.clone();
            try {
                region.shift(hybridPlotWorld.getPlotSchematicMinPoint().add((int)relativeOffsetX, 0, (int)relativeOffsetZ).subtract(hybridPlotWorld.PATH_WIDTH_LOWER + 1, 0, hybridPlotWorld.PATH_WIDTH_LOWER + 1));
                for (Entity entity : hybridPlotWorld.getPlotSchematicEntities()) {
                    if (!region.contains(entity.getLocation().toVector().toBlockPoint())) continue;
                    Vector3 pos = entity.getLocation().toVector().subtract(region.getMinimumPoint().withY(hybridPlotWorld.getPlotSchematicMinPoint().getY()).toVector3()).add(min.getBlockVector3().withY(hybridPlotWorld.SCHEM_Y).toVector3());
                    result.setEntity(new PopulatingEntity(entity, new com.sk89q.worldedit.util.Location((Extent)NullWorld.getInstance(), pos)));
                }
            }
            catch (RegionOperationException e) {
                throw new RuntimeException(e);
            }
            if (overlap) {
                try {
                    region.shift(BlockVector3.at((int)(-hybridPlotWorld.SIZE), (int)0, (int)(-hybridPlotWorld.SIZE)));
                    for (Entity entity : hybridPlotWorld.getPlotSchematicEntities()) {
                        if (!region.contains(entity.getLocation().toVector().toBlockPoint())) continue;
                        result.setEntity(entity);
                    }
                }
                catch (RegionOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public PlotArea getNewPlotArea(String world, String id, PlotId min, PlotId max) {
        return this.hybridPlotWorldFactory.create(world, id, this, min, max);
    }

    @Override
    public void initialize(PlotArea area) {
    }

    @Override
    public BiomeType getBiome(PlotArea settings, int worldX, int worldY, int worldZ) {
        int size;
        BiomeType biome;
        HybridPlotWorld hybridPlotWorld = (HybridPlotWorld)settings;
        if (!hybridPlotWorld.PLOT_SCHEMATIC && !hybridPlotWorld.ROAD_SCHEMATIC_ENABLED) {
            return hybridPlotWorld.getPlotBiome();
        }
        int relativeX = worldX;
        int relativeZ = worldZ;
        if (hybridPlotWorld.ROAD_OFFSET_X != 0) {
            relativeX -= hybridPlotWorld.ROAD_OFFSET_X;
        }
        if (hybridPlotWorld.ROAD_OFFSET_Z != 0) {
            relativeZ -= hybridPlotWorld.ROAD_OFFSET_Z;
        }
        return (biome = hybridPlotWorld.G_SCH_B.get(MathMan.pair((short)(relativeX = Math.floorMod(relativeX, size = hybridPlotWorld.PLOT_WIDTH + hybridPlotWorld.ROAD_WIDTH)), (short)(relativeZ = Math.floorMod(relativeZ, size))))) == null ? hybridPlotWorld.getPlotBiome() : biome;
    }

    private static enum SchematicFeature {
        BIOMES,
        ROAD,
        POPULATING;

    }

    private static final class PopulatingEntity
    implements Entity {
        private final Entity parent;
        private com.sk89q.worldedit.util.Location location;

        private PopulatingEntity(Entity parent, com.sk89q.worldedit.util.Location location) {
            this.parent = parent;
            this.location = location;
        }

        public @Nullable BaseEntity getState() {
            return this.parent.getState();
        }

        public boolean remove() {
            return this.parent.remove();
        }

        public com.sk89q.worldedit.util.Location getLocation() {
            return this.location;
        }

        public boolean setLocation(com.sk89q.worldedit.util.Location location) {
            this.location = location;
            return true;
        }

        public Extent getExtent() {
            return this.parent.getExtent();
        }

        public <T> @Nullable T getFacet(Class<? extends T> cls) {
            return (T)this.parent.getFacet(cls);
        }
    }
}

