/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.http.ContentType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class EntityMapper {
    private final Map<Class<?>, EntitySerializer<?>> serializers = new HashMap();
    private final Map<Class<?>, EntityDeserializer<?>> deserializers = new HashMap();

    private static <T> T castUnsafe(@NotNull Object o) {
        return (T)o;
    }

    @NotNull
    public static EntityMapper newInstance() {
        EntityMapper mapper = new EntityMapper();
        mapper.registerDeserializer(String.class, new StringDeserializer());
        mapper.registerSerializer(String.class, new StringSerializer());
        return mapper;
    }

    @NotNull
    public <T> EntityMapper registerSerializer(@NotNull Class<T> clazz, @NotNull EntitySerializer<T> serializer) {
        Objects.requireNonNull(clazz, "Class may not be null");
        Objects.requireNonNull(serializer, "Serializer may not be null");
        this.serializers.put(clazz, serializer);
        return this;
    }

    @NotNull
    public <T> EntityMapper registerDeserializer(@NotNull Class<T> clazz, @NotNull EntityDeserializer<T> deserializer) {
        Objects.requireNonNull(clazz, "Type may not be null");
        Objects.requireNonNull(deserializer, "Deserializer may not be null");
        this.deserializers.put(clazz, deserializer);
        return this;
    }

    public <T> Optional<EntitySerializer<T>> getSerializer(@NotNull Class<T> clazz) {
        EntitySerializer<?> serializer = this.serializers.get(clazz);
        if (serializer == null) {
            return Optional.empty();
        }
        return Optional.of((EntitySerializer)EntityMapper.castUnsafe(serializer));
    }

    public <T> Optional<EntityDeserializer<T>> getDeserializer(@NotNull Class<T> type) {
        EntityDeserializer<?> entityDeserializer = this.deserializers.get(type);
        if (entityDeserializer == null) {
            return Optional.empty();
        }
        return Optional.of(entityDeserializer);
    }

    private static final class StringDeserializer
    implements EntityDeserializer<String> {
        private StringDeserializer() {
        }

        @Override
        @NotNull
        public String deserialize(@Nullable ContentType contentType, @NotNull byte[] input) {
            Charset charset = contentType != null && contentType.toString().toLowerCase().contains("utf-8") ? StandardCharsets.UTF_8 : (contentType != null && contentType.toString().toLowerCase().contains("utf-16") ? StandardCharsets.UTF_16 : StandardCharsets.US_ASCII);
            return new String(input, charset);
        }
    }

    @FunctionalInterface
    public static interface EntityDeserializer<T> {
        @NotNull
        public T deserialize(@Nullable ContentType var1, @NotNull byte[] var2);
    }

    private static final class StringSerializer
    implements EntitySerializer<String> {
        private StringSerializer() {
        }

        @Override
        @NotNull
        public byte[] serialize(@NotNull String string) {
            return string.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public ContentType getContentType() {
            return ContentType.STRING_UTF8;
        }
    }

    public static interface EntitySerializer<T> {
        @NotNull
        public byte[] serialize(@NotNull T var1);

        public ContentType getContentType();
    }
}

