/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.http.EntityMapper;
import com.plotsquared.core.http.Headers;
import com.plotsquared.core.http.HttpMethod;
import com.plotsquared.core.http.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class HttpRequest {
    private static final int READ_TIMEOUT = 3600000;
    @NotNull
    private final HttpMethod method;
    @NotNull
    private final URL url;
    @NotNull
    private final Headers headers;
    @NotNull
    private final EntityMapper mapper;
    @Nullable
    private final Supplier<Object> inputSupplier;
    @NotNull
    private final Consumer<Throwable> throwableConsumer;

    private HttpRequest(@NotNull HttpMethod method, @NotNull URL url, @NotNull Headers headers, @Nullable Supplier<Object> inputSupplier, @NotNull EntityMapper mapper, @NotNull Consumer<Throwable> throwableConsumer) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.inputSupplier = inputSupplier;
        this.mapper = mapper;
        this.throwableConsumer = throwableConsumer;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    HttpResponse executeRequest() throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
        try {
            Object object;
            httpURLConnection.setRequestMethod(this.method.name());
            httpURLConnection.setDoOutput(this.method.hasBody());
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setReadTimeout(3600000);
            for (String headerName : this.headers.getHeaders()) {
                List<String> headers = this.headers.getHeaders(headerName);
                if (headers.size() == 1) {
                    httpURLConnection.addRequestProperty(headerName, headers.get(0));
                    continue;
                }
                if (headers.size() <= 1) continue;
                StringBuilder stringBuilder = new StringBuilder();
                Iterator<String> headerIterator = headers.iterator();
                while (headerIterator.hasNext()) {
                    stringBuilder.append(headerIterator.next());
                    if (!headerIterator.hasNext()) continue;
                    stringBuilder.append(',');
                }
                httpURLConnection.addRequestProperty(headerName, stringBuilder.toString());
            }
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(this.inputSupplier != null);
            if (this.inputSupplier != null && (object = this.inputSupplier.get()) != null) {
                EntityMapper.EntitySerializer<?> serializer = this.mapper.getSerializer(object.getClass()).orElseThrow(() -> new IllegalArgumentException(String.format("There is no registered serializer for type '%s'", object.getClass().getCanonicalName())));
                if (this.headers.getHeader("Content-Type").isEmpty()) {
                    httpURLConnection.setRequestProperty("Content-Type", serializer.getContentType().toString());
                }
                Object bytes = serializer.serialize(object);
                httpURLConnection.setRequestProperty("Content-Length", Integer.toString(((Object)bytes).length));
                try (DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());){
                    dataOutputStream.write((byte[])bytes);
                    dataOutputStream.flush();
                }
            }
            httpURLConnection.connect();
            InputStream stream = this.method.hasBody() ? (httpURLConnection.getResponseCode() != 200 ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream()) : null;
            HttpResponse.Builder builder = HttpResponse.builder().withStatus(httpURLConnection.getResponseCode()).withStatusMessage(httpURLConnection.getResponseMessage()).withEntityMapper(this.mapper);
            for (Map.Entry entry : httpURLConnection.getHeaderFields().entrySet()) {
                if (entry.getKey() == null) continue;
                for (String header : (List)entry.getValue()) {
                    builder.withHeader((String)entry.getKey(), header);
                }
            }
            if (stream != null) {
                try (InputStream copy = stream;
                     ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    int b;
                    while ((b = stream.read()) != -1) {
                        byteArrayOutputStream.write(b);
                    }
                    builder.withBody(byteArrayOutputStream.toByteArray());
                }
            }
            HttpResponse httpResponse = builder.build();
            return httpResponse;
        }
        catch (Throwable throwable) {
            this.throwableConsumer.accept(throwable);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return null;
    }

    static final class Builder {
        private final Headers headers = Headers.newInstance();
        private EntityMapper mapper;
        private HttpMethod method;
        private URL url;
        private Supplier<Object> inputSupplier;
        private Consumer<Throwable> throwableConsumer = Throwable::printStackTrace;

        private Builder() {
        }

        @NotNull
        Builder withMapper(@NotNull EntityMapper mapper) {
            this.mapper = Objects.requireNonNull(mapper, "Mapper may not be null");
            return this;
        }

        @NotNull
        Builder withMethod(@NotNull HttpMethod method) {
            this.method = Objects.requireNonNull(method, "Method may not be null");
            return this;
        }

        @NotNull
        Builder withURL(@NotNull URL url) {
            this.url = Objects.requireNonNull(url, "URL may not be null");
            return this;
        }

        @NotNull
        Builder withHeader(@NotNull String key, @NotNull String value) {
            this.headers.addHeader(Objects.requireNonNull(key, "Key may not be null"), Objects.requireNonNull(value, "Value may not be null"));
            return this;
        }

        @NotNull
        Builder withInput(@NotNull Supplier<Object> inputSupplier) {
            this.inputSupplier = Objects.requireNonNull(inputSupplier, "Input supplier may not be null");
            return this;
        }

        @NotNull
        Builder onException(@NotNull Consumer<Throwable> consumer) {
            this.throwableConsumer = Objects.requireNonNull(consumer, "Consumer may not be null");
            return this;
        }

        @NotNull
        HttpRequest build() {
            Objects.requireNonNull(this.method, "No method was supplied");
            Objects.requireNonNull(this.url, "No URL was supplied");
            Objects.requireNonNull(this.mapper, "No mapper was supplied");
            Objects.requireNonNull(this.throwableConsumer, "No throwable consumer was supplied");
            return new HttpRequest(this.method, this.url, this.headers, this.inputSupplier, this.mapper, this.throwableConsumer);
        }
    }
}

