/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.permissions;

import com.plotsquared.core.permissions.Permission;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface PermissionHolder {
    default public boolean hasPermission(@NonNull String permission) {
        return this.hasPermission(null, permission);
    }

    default public boolean hasPermission(@NonNull Permission permission) {
        return this.hasPermission(permission.toString());
    }

    default public boolean hasKeyedPermission(@NonNull String permission, @NonNull String key) {
        return this.hasKeyedPermission(null, permission, key);
    }

    default public @NonNegative int hasPermissionRange(@NonNull Permission stub, @NonNegative int range) {
        return this.hasPermissionRange(stub.toString(), range);
    }

    default public @NonNegative int hasPermissionRange(@NonNull String stub, @NonNegative int range) {
        int i;
        if (this.hasPermission(Permission.PERMISSION_ADMIN.toString())) {
            return Integer.MAX_VALUE;
        }
        String[] nodes = stub.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < nodes.length - 1; ++i) {
            builder.append(nodes[i]).append(".");
            if (stub.equals(builder + Permission.PERMISSION_STAR.toString()) || !this.hasPermission(builder + Permission.PERMISSION_STAR.toString())) continue;
            return Integer.MAX_VALUE;
        }
        if (this.hasPermission(stub + ".*")) {
            return Integer.MAX_VALUE;
        }
        for (i = range; i > 0; --i) {
            if (!this.hasPermission(stub + "." + i)) continue;
            return i;
        }
        return 0;
    }

    default public boolean hasPermission(@NonNull Permission permission, boolean notify) {
        return this.hasPermission(permission.toString(), notify);
    }

    public boolean hasPermission(@NonNull String var1, boolean var2);

    public boolean hasPermission(@Nullable String var1, @NonNull String var2);

    public boolean hasKeyedPermission(@Nullable String var1, @NonNull String var2, @NonNull String var3);
}

