/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.expiration;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.implementations.AnalysisFlag;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlotAnalysis {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotAnalysis.class.getSimpleName()));
    public static boolean running = false;
    public int changes;
    public int faces;
    public int data;
    public int air;
    public int variety;
    public int changes_sd;
    public int faces_sd;
    public int data_sd;
    public int air_sd;
    public int variety_sd;
    private int complexity;

    public static PlotAnalysis getAnalysis(Plot plot, Settings.Auto_Clear settings) {
        List values = (List)plot.getFlag(AnalysisFlag.class);
        if (!values.isEmpty()) {
            PlotAnalysis analysis = new PlotAnalysis();
            analysis.changes = (Integer)values.get(0);
            analysis.faces = (Integer)values.get(1);
            analysis.data = (Integer)values.get(2);
            analysis.air = (Integer)values.get(3);
            analysis.variety = (Integer)values.get(4);
            analysis.changes_sd = (Integer)values.get(5);
            analysis.faces_sd = (Integer)values.get(6);
            analysis.data_sd = (Integer)values.get(7);
            analysis.air_sd = (Integer)values.get(8);
            analysis.variety_sd = (Integer)values.get(9);
            analysis.complexity = settings != null ? analysis.getComplexity(settings) : 0;
            return analysis;
        }
        return null;
    }

    public static void analyzePlot(Plot plot, RunnableVal<PlotAnalysis> whenDone) {
        PlotSquared.platform().injector().getInstance(HybridUtils.class).analyzePlot(plot, whenDone);
    }

    public static void calcOptimalModifiers(final Runnable whenDone, final double threshold) {
        if (running) {
            LOGGER.info("Calibration task already in progress!");
            return;
        }
        if (threshold <= 0.0 || threshold >= 1.0) {
            LOGGER.info("Invalid threshold provided! (Cannot be 0 or 100 as then there's no point in calibrating)");
            return;
        }
        running = true;
        final List<Plot> plots = PlotQuery.newQuery().allPlots().asList();
        TaskManager.runTaskAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Plot queuePlot;
                Iterator iterator = plots.iterator();
                LOGGER.info("- Reducing {} plots to those with sufficient data", (Object)plots.size());
                while (iterator.hasNext()) {
                    Plot plot = (Plot)iterator.next();
                    if (plot.getSettings().getRatings() == null || plot.getSettings().getRatings().isEmpty()) {
                        iterator.remove();
                        continue;
                    }
                    plot.addRunning();
                }
                if (plots.size() < 3) {
                    LOGGER.info("Calibration cancelled due to insufficient comparison data, please try again later");
                    running = false;
                    for (Plot plot : plots) {
                        plot.removeRunning();
                    }
                    return;
                }
                LOGGER.info("- Analyzing plot contents (this may take a while)");
                int[] changes = new int[plots.size()];
                int[] faces = new int[plots.size()];
                int[] data = new int[plots.size()];
                int[] air = new int[plots.size()];
                int[] variety = new int[plots.size()];
                int[] changes_sd = new int[plots.size()];
                int[] faces_sd = new int[plots.size()];
                int[] data_sd = new int[plots.size()];
                int[] air_sd = new int[plots.size()];
                int[] variety_sd = new int[plots.size()];
                int[] ratings = new int[plots.size()];
                AtomicInteger mi = new AtomicInteger(0);
                Thread ratingAnalysis = new Thread(() -> {
                    while (mi.intValue() < plots.size()) {
                        int i = mi.intValue();
                        Plot plot = (Plot)plots.get(i);
                        ratings[i] = (int)((plot.getAverageRating() + (double)plot.getSettings().getRatings().size()) * 100.0);
                        LOGGER.info(" | {} (rating) {}", (Object)plot, (Object)ratings[i]);
                        mi.incrementAndGet();
                    }
                });
                ratingAnalysis.start();
                ArrayDeque plotsQueue = new ArrayDeque(plots);
                while ((queuePlot = (Plot)plotsQueue.poll()) != null) {
                    LOGGER.info(" | {}", (Object)queuePlot);
                    final Object lock = new Object();
                    TaskManager.runTask(new Runnable(){

                        @Override
                        public void run() {
                            PlotAnalysis.analyzePlot(queuePlot, new RunnableVal<PlotAnalysis>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run(PlotAnalysis value) {
                                    Object object;
                                    try {
                                        object = this;
                                        synchronized (object) {
                                            this.wait(10000L);
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                    object = lock;
                                    synchronized (object) {
                                        queuePlot.removeRunning();
                                        lock.notify();
                                    }
                                }
                            });
                        }
                    });
                    try {
                        Object object = lock;
                        synchronized (object) {
                            lock.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                LOGGER.info("- Waiting on plot rating thread: {}%", (Object)(mi.intValue() * 100 / plots.size()));
                try {
                    ratingAnalysis.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                LOGGER.info("- Processing and grouping single plot analysis for bulk processing");
                for (int i = 0; i < plots.size(); ++i) {
                    Plot plot = (Plot)plots.get(i);
                    LOGGER.info("| {}", (Object)plot);
                    PlotAnalysis analysis = plot.getComplexity(null);
                    changes[i] = analysis.changes;
                    faces[i] = analysis.faces;
                    data[i] = analysis.data;
                    air[i] = analysis.air;
                    variety[i] = analysis.variety;
                    changes_sd[i] = analysis.changes_sd;
                    faces_sd[i] = analysis.faces_sd;
                    data_sd[i] = analysis.data_sd;
                    air_sd[i] = analysis.air_sd;
                    variety_sd[i] = analysis.variety_sd;
                }
                LOGGER.info("- Calculating rankings");
                int[] rankRatings = PlotAnalysis.rank(ratings);
                int n = rankRatings.length;
                int optimalIndex = (int)Math.round((1.0 - threshold) * (double)(n - 1));
                LOGGER.info("- Calculating rank correlation: ");
                LOGGER.info("- The analyzed plots which were processed and put into bulk data will be compared and correlated to the plot ranking");
                LOGGER.info("- The calculated correlation constant will then be used to calibrate the threshold for auto plot clearing");
                Settings.Auto_Clear settings = new Settings.Auto_Clear();
                int[] rankChanges = PlotAnalysis.rank(changes);
                int[] sdChanges = PlotAnalysis.getSD(rankChanges, rankRatings);
                int[] varianceChanges = PlotAnalysis.square(sdChanges);
                int sumChanges = PlotAnalysis.sum(varianceChanges);
                double factorChanges = PlotAnalysis.getCC(n, sumChanges);
                settings.CALIBRATION.CHANGES = factorChanges == 1.0 ? 0 : (int)(factorChanges * 1000.0 / MathMan.getMean(changes));
                LOGGER.info("- | changes {}", (Object)factorChanges);
                int[] rankFaces = PlotAnalysis.rank(faces);
                int[] sdFaces = PlotAnalysis.getSD(rankFaces, rankRatings);
                int[] varianceFaces = PlotAnalysis.square(sdFaces);
                int sumFaces = PlotAnalysis.sum(varianceFaces);
                double factorFaces = PlotAnalysis.getCC(n, sumFaces);
                settings.CALIBRATION.FACES = factorFaces == 1.0 ? 0 : (int)(factorFaces * 1000.0 / MathMan.getMean(faces));
                LOGGER.info("- | faces {}", (Object)factorFaces);
                int[] rankData = PlotAnalysis.rank(data);
                int[] sdData = PlotAnalysis.getSD(rankData, rankRatings);
                int[] variance_data = PlotAnalysis.square(sdData);
                int sum_data = PlotAnalysis.sum(variance_data);
                double factor_data = PlotAnalysis.getCC(n, sum_data);
                settings.CALIBRATION.DATA = factor_data == 1.0 ? 0 : (int)(factor_data * 1000.0 / MathMan.getMean(data));
                LOGGER.info("- | data {}", (Object)factor_data);
                int[] rank_air = PlotAnalysis.rank(air);
                int[] sd_air = PlotAnalysis.getSD(rank_air, rankRatings);
                int[] variance_air = PlotAnalysis.square(sd_air);
                int sum_air = PlotAnalysis.sum(variance_air);
                double factor_air = PlotAnalysis.getCC(n, sum_air);
                settings.CALIBRATION.AIR = factor_air == 1.0 ? 0 : (int)(factor_air * 1000.0 / MathMan.getMean(air));
                LOGGER.info("- | air {}", (Object)factor_air);
                int[] rank_variety = PlotAnalysis.rank(variety);
                int[] sd_variety = PlotAnalysis.getSD(rank_variety, rankRatings);
                int[] variance_variety = PlotAnalysis.square(sd_variety);
                int sum_variety = PlotAnalysis.sum(variance_variety);
                double factor_variety = PlotAnalysis.getCC(n, sum_variety);
                settings.CALIBRATION.VARIETY = factor_variety == 1.0 ? 0 : (int)(factor_variety * 1000.0 / MathMan.getMean(variety));
                LOGGER.info("- | variety {}", (Object)factor_variety);
                int[] rank_changes_sd = PlotAnalysis.rank(changes_sd);
                int[] sd_changes_sd = PlotAnalysis.getSD(rank_changes_sd, rankRatings);
                int[] variance_changes_sd = PlotAnalysis.square(sd_changes_sd);
                int sum_changes_sd = PlotAnalysis.sum(variance_changes_sd);
                double factor_changes_sd = PlotAnalysis.getCC(n, sum_changes_sd);
                settings.CALIBRATION.CHANGES_SD = factor_changes_sd == 1.0 ? 0 : (int)(factor_changes_sd * 1000.0 / MathMan.getMean(changes_sd));
                LOGGER.info("- | changed_sd {}", (Object)factor_changes_sd);
                int[] rank_faces_sd = PlotAnalysis.rank(faces_sd);
                int[] sd_faces_sd = PlotAnalysis.getSD(rank_faces_sd, rankRatings);
                int[] variance_faces_sd = PlotAnalysis.square(sd_faces_sd);
                int sum_faces_sd = PlotAnalysis.sum(variance_faces_sd);
                double factor_faces_sd = PlotAnalysis.getCC(n, sum_faces_sd);
                settings.CALIBRATION.FACES_SD = factor_faces_sd == 1.0 ? 0 : (int)(factor_faces_sd * 1000.0 / MathMan.getMean(faces_sd));
                LOGGER.info("- | faced_sd {}", (Object)factor_faces_sd);
                int[] rank_data_sd = PlotAnalysis.rank(data_sd);
                int[] sd_data_sd = PlotAnalysis.getSD(rank_data_sd, rankRatings);
                int[] variance_data_sd = PlotAnalysis.square(sd_data_sd);
                int sum_data_sd = PlotAnalysis.sum(variance_data_sd);
                double factor_data_sd = PlotAnalysis.getCC(n, sum_data_sd);
                settings.CALIBRATION.DATA_SD = factor_data_sd == 1.0 ? 0 : (int)(factor_data_sd * 1000.0 / MathMan.getMean(data_sd));
                LOGGER.info("- | data_sd {}", (Object)factor_data_sd);
                int[] rank_air_sd = PlotAnalysis.rank(air_sd);
                int[] sd_air_sd = PlotAnalysis.getSD(rank_air_sd, rankRatings);
                int[] variance_air_sd = PlotAnalysis.square(sd_air_sd);
                int sum_air_sd = PlotAnalysis.sum(variance_air_sd);
                double factor_air_sd = PlotAnalysis.getCC(n, sum_air_sd);
                settings.CALIBRATION.AIR_SD = factor_air_sd == 1.0 ? 0 : (int)(factor_air_sd * 1000.0 / MathMan.getMean(air_sd));
                LOGGER.info("- | air_sd {}", (Object)factor_air_sd);
                int[] rank_variety_sd = PlotAnalysis.rank(variety_sd);
                int[] sd_variety_sd = PlotAnalysis.getSD(rank_variety_sd, rankRatings);
                int[] variance_variety_sd = PlotAnalysis.square(sd_variety_sd);
                int sum_variety_sd = PlotAnalysis.sum(variance_variety_sd);
                double factor_variety_sd = PlotAnalysis.getCC(n, sum_variety_sd);
                settings.CALIBRATION.VARIETY_SD = factor_variety_sd == 1.0 ? 0 : (int)(factor_variety_sd * 1000.0 / MathMan.getMean(variety_sd));
                LOGGER.info("- | variety_sd {}", (Object)factor_variety_sd);
                int[] complexity = new int[n];
                LOGGER.info("Calculating threshold");
                int max = 0;
                int min = 0;
                for (int i = 0; i < n; ++i) {
                    Plot plot = (Plot)plots.get(i);
                    PlotAnalysis analysis = plot.getComplexity(settings);
                    complexity[i] = analysis.complexity;
                    if (analysis.complexity < min) {
                        min = analysis.complexity;
                        continue;
                    }
                    if (analysis.complexity <= max) continue;
                    max = analysis.complexity;
                }
                int optimalComplexity = Integer.MAX_VALUE;
                if (min > 0 && max < 102400) {
                    int[] rankComplexity = PlotAnalysis.rank(complexity, max + 1);
                    for (int i = 0; i < n; ++i) {
                        if (rankComplexity[i] != optimalIndex) continue;
                        optimalComplexity = complexity[i];
                        break;
                    }
                    PlotAnalysis.logln("Complexity: ");
                    PlotAnalysis.logln(rankComplexity);
                    PlotAnalysis.logln("Ratings: ");
                    PlotAnalysis.logln(rankRatings);
                    PlotAnalysis.logln("Correlation: ");
                    PlotAnalysis.logln(PlotAnalysis.getCC(n, PlotAnalysis.sum(PlotAnalysis.square(PlotAnalysis.getSD(rankComplexity, rankRatings)))));
                    if (optimalComplexity == Integer.MAX_VALUE) {
                        LOGGER.info("Insufficient data to determine correlation! {} | {}", (Object)optimalIndex, (Object)n);
                        running = false;
                        for (Plot plot : plots) {
                            plot.removeRunning();
                        }
                        return;
                    }
                } else {
                    int[] sorted = (int[])complexity.clone();
                    PlotAnalysis.sort(sorted);
                    PlotAnalysis.logln("Complexity: ");
                    PlotAnalysis.logln(complexity);
                    PlotAnalysis.logln("Ratings: ");
                    PlotAnalysis.logln(rankRatings);
                }
                LOGGER.info("Saving calibration");
                Settings.AUTO_CLEAR.put("auto-calibrated", settings);
                Settings.save(PlotSquared.get().getWorldsFile());
                running = false;
                for (Plot plot : plots) {
                    plot.removeRunning();
                }
                LOGGER.info("Done!");
                whenDone.run();
            }
        });
    }

    public static void logln(Object obj) {
        LOGGER.info(PlotAnalysis.log(obj));
    }

    public static String log(Object obj) {
        StringBuilder result = new StringBuilder();
        if (obj.getClass().isArray()) {
            String prefix = "";
            for (int i = 0; i < Array.getLength(obj); ++i) {
                result.append(prefix).append(PlotAnalysis.log(Array.get(obj, i)));
                prefix = ",";
            }
            return "( " + result + " )";
        }
        if (obj instanceof List) {
            String prefix = "";
            for (Object element : (List)obj) {
                result.append(prefix).append(PlotAnalysis.log(element));
                prefix = ",";
            }
            return "[ " + result + " ]";
        }
        return obj.toString();
    }

    public static double getCC(int n, int sum) {
        return 1.0 - 6.0 * (double)sum / (double)(n * (n * n - 1));
    }

    public static int sum(int[] array) {
        return Arrays.stream(array).sum();
    }

    public static int[] square(int[] array) {
        array = (int[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            int n = i;
            array[n] = array[n] * array[i];
        }
        return array;
    }

    public static int[] getSD(int[] ... ranks) {
        if (ranks.length == 0) {
            return null;
        }
        int[] result = new int[ranks[0].length];
        for (int j = 0; j < ranks[0].length; ++j) {
            int sum = 0;
            for (int[] rank : ranks) {
                sum += rank[j];
            }
            int mean = sum / ranks.length;
            int sd = 0;
            for (int[] rank : ranks) {
                int value = rank[j];
                sd += value < mean ? mean - value : value - mean;
            }
            result[j] = sd;
        }
        return result;
    }

    public static int[] rank(int[] input) {
        return PlotAnalysis.rank(input, 102400);
    }

    public static int[] rank(int[] input, int size) {
        int[] cache = new int[size];
        int max = 0;
        if (input.length < size) {
            for (int value : input) {
                if (value > max) {
                    max = value;
                }
                int n = value;
                cache[n] = cache[n] + 1;
            }
        } else {
            max = cache.length - 1;
            int[] nArray = input;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int value;
                int n2 = value = nArray[i];
                cache[n2] = cache[n2] + 1;
            }
        }
        int last = 0;
        for (int i = max; i >= 0; --i) {
            if (cache[i] == 0) continue;
            int n = i;
            cache[n] = cache[n] + last;
            last = cache[i];
            if (last == input.length) break;
        }
        int[] ranks = new int[input.length];
        for (int i = 0; i < input.length; ++i) {
            int index = input[i];
            ranks[i] = cache[index];
            int n = index;
            cache[n] = cache[n] - 1;
        }
        return ranks;
    }

    public static void sort(int[] input) {
        int SIZE = 10;
        ArrayList[] bucket = new ArrayList[SIZE];
        for (int i = 0; i < bucket.length; ++i) {
            bucket[i] = new ArrayList();
        }
        boolean maxLength = false;
        int placement = 1;
        while (!maxLength) {
            maxLength = true;
            int[] nArray = input;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer i2 = nArray[i];
                int tmp = i2 / placement;
                bucket[tmp % SIZE].add(i2);
                if (!maxLength || tmp <= 0) continue;
                maxLength = false;
            }
            int a = 0;
            for (int b = 0; b < SIZE; ++b) {
                for (Integer i2 : bucket[b]) {
                    input[a++] = i2;
                }
                bucket[b].clear();
            }
            placement *= SIZE;
        }
    }

    public List<Integer> asList() {
        return Arrays.asList(this.changes, this.faces, this.data, this.air, this.variety, this.changes_sd, this.faces_sd, this.data_sd, this.air_sd, this.variety_sd);
    }

    public int getComplexity(Settings.Auto_Clear settings) {
        Settings.Auto_Clear.CALIBRATION modifiers = settings.CALIBRATION;
        if (this.complexity != 0) {
            return this.complexity;
        }
        this.complexity = this.changes * modifiers.CHANGES + this.faces * modifiers.FACES + this.data * modifiers.DATA + this.air * modifiers.AIR + this.variety * modifiers.VARIETY + this.changes_sd * modifiers.CHANGES_SD + this.faces_sd * modifiers.FACES_SD + this.data_sd * modifiers.DATA_SD + this.air_sd * modifiers.AIR_SD + this.variety_sd * modifiers.VARIETY_SD;
        return this.complexity;
    }
}

