/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DenyTeleportFlag
extends PlotFlag<DeniedGroup, DenyTeleportFlag> {
    public static final DenyTeleportFlag DENY_TELEPORT_FLAG_NONE = new DenyTeleportFlag(DeniedGroup.NONE);

    protected DenyTeleportFlag(@NonNull DeniedGroup value) {
        super(value, TranslatableCaption.of("flags.flag_category_enum"), TranslatableCaption.of("flags.flag_description_deny_teleport"));
    }

    public static boolean allowsTeleport(PlotPlayer<?> player, Plot plot) {
        boolean result;
        DeniedGroup value = (DeniedGroup)((Object)plot.getFlag(DenyTeleportFlag.class));
        if (value == DeniedGroup.NONE) {
            return true;
        }
        switch (value) {
            case TRUSTED: {
                result = !plot.getTrusted().contains(player.getUUID());
                break;
            }
            case MEMBERS: {
                result = !plot.getMembers().contains(player.getUUID());
                break;
            }
            case NONMEMBERS: {
                result = plot.isAdded(player.getUUID());
                break;
            }
            case NONTRUSTED: {
                result = plot.getTrusted().contains(player.getUUID()) || plot.isOwner(player.getUUID());
                break;
            }
            case NONOWNERS: {
                result = plot.isOwner(player.getUUID());
                break;
            }
            default: {
                return true;
            }
        }
        return result || player.hasPermission("plots.admin.entry.denied");
    }

    @Override
    public DenyTeleportFlag parse(@NonNull String input) throws FlagParseException {
        DeniedGroup group = DeniedGroup.fromString(input);
        if (group == null) {
            throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_enum"), TagResolver.resolver("list", Tag.inserting(Component.text("members, nonmembers, trusted, nontrusted, nonowners"))));
        }
        return this.flagOf(group);
    }

    @Override
    public DenyTeleportFlag merge(@NonNull DeniedGroup newValue) {
        if (((DeniedGroup)((Object)this.getValue())).ordinal() < newValue.ordinal()) {
            return this.flagOf(newValue);
        }
        return this;
    }

    @Override
    public String toString() {
        return ((DeniedGroup)((Object)this.getValue())).name();
    }

    @Override
    public String getExample() {
        return "trusted";
    }

    @Override
    protected DenyTeleportFlag flagOf(@NonNull DeniedGroup value) {
        return new DenyTeleportFlag(value);
    }

    @Override
    public Collection<String> getTabCompletions() {
        return Arrays.asList("none", "members", "trusted", "nonmembers", "nontrusted", "nonowners");
    }

    public static enum DeniedGroup {
        NONE,
        MEMBERS,
        TRUSTED,
        NONMEMBERS,
        NONTRUSTED,
        NONOWNERS;


        public static @Nullable DeniedGroup fromString(@NonNull String string) {
            for (DeniedGroup group : DeniedGroup.values()) {
                if (!group.name().equalsIgnoreCase(string)) continue;
                return group;
            }
            return null;
        }
    }
}

