/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.arkitektonika.Arkitektonika;
import com.plotsquared.core.arkitektonika.SchematicKeys;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.google.Inject;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.Tag;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlotUploader {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotUploader.class.getSimpleName()));
    private static final Path TEMP_DIR = Paths.get(PlotSquared.platform().getDirectory().getPath(), new String[0]);
    private final SchematicHandler schematicHandler;
    private final Arkitektonika arkitektonika;

    @Inject
    public PlotUploader(@NonNull SchematicHandler schematicHandler) {
        this.schematicHandler = schematicHandler;
        this.arkitektonika = Arkitektonika.builder().withUrl(Settings.Arkitektonika.BACKEND_URL).build();
    }

    public CompletableFuture<PlotUploadResult> upload(@NonNull Plot plot) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.schematicHandler.getCompoundTag(plot).handle((tag, t) -> {
            plot.removeRunning();
            return tag;
        })).thenApply(this::writeToTempFile)).thenApply(this::uploadAndDelete)).thenApply(this::wrapIntoResult);
    }

    private @NonNull PlotUploadResult wrapIntoResult(@Nullable SchematicKeys schematicKeys) {
        if (schematicKeys == null) {
            return PlotUploadResult.failed();
        }
        String download = Settings.Arkitektonika.DOWNLOAD_URL.replace("{key}", schematicKeys.getAccessKey());
        String delete = Settings.Arkitektonika.DELETE_URL.replace("{key}", schematicKeys.getDeletionKey());
        return PlotUploadResult.success(download, delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable SchematicKeys uploadAndDelete(@NonNull Path file) {
        try {
            CompletableFuture<SchematicKeys> upload = this.arkitektonika.upload(file.toFile());
            SchematicKeys schematicKeys = upload.join();
            return schematicKeys;
        }
        catch (CompletionException e) {
            LOGGER.error("Failed to upload schematic", (Throwable)e);
            SchematicKeys schematicKeys = null;
            return schematicKeys;
        }
        finally {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete temporary file {}", (Object)file, (Object)e);
            }
        }
    }

    private @NonNull Path writeToTempFile(@NonNull CompoundTag schematic) {
        try {
            Path tempFile = Files.createTempFile(TEMP_DIR, null, null, new FileAttribute[0]);
            try (OutputStream stream = Files.newOutputStream(tempFile, new OpenOption[0]);){
                this.writeSchematic(schematic, stream);
            }
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeSchematic(@NonNull CompoundTag schematic, @NonNull OutputStream stream) throws IOException {
        try (NBTOutputStream nbtOutputStream = new NBTOutputStream((OutputStream)new GZIPOutputStream(stream));){
            nbtOutputStream.writeNamedTag("Schematic", (Tag)schematic);
        }
    }

    public static class PlotUploadResult {
        private final boolean success;
        private final String downloadUrl;
        private final String deletionUrl;

        private PlotUploadResult(boolean success, @Nullable String downloadUrl, @Nullable String deletionUrl) {
            this.success = success;
            this.downloadUrl = downloadUrl;
            this.deletionUrl = deletionUrl;
        }

        private static @NonNull PlotUploadResult success(@NonNull String downloadUrl, @Nullable String deletionUrl) {
            return new PlotUploadResult(true, downloadUrl, deletionUrl);
        }

        private static @NonNull PlotUploadResult failed() {
            return new PlotUploadResult(false, null, null);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public String getDeletionUrl() {
            return this.deletionUrl;
        }
    }
}

