/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.helpmenu;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.command.Argument;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.ComponentLike;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.StringMan;

public class HelpObject
implements ComponentLike {
    static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final Component rendered;

    public HelpObject(Command command, String label, PlotPlayer<?> audience) {
        this.rendered = MINI_MESSAGE.deserialize(TranslatableCaption.of("help.help_item").getComponent(audience), TagResolver.builder().tag("usage", Tag.inserting(Component.text(command.getUsage().replace("{label}", label)))).tag("alias", Tag.inserting(Component.text(command.getAliases().isEmpty() ? "" : StringMan.join(command.getAliases(), " | ")))).tag("desc", Tag.inserting(command.getDescription().toComponent(audience))).tag("arguments", Tag.inserting(Component.text(this.buildArgumentList(command.getRequiredArguments())))).tag("label", Tag.inserting(Component.text(label))).build());
    }

    private String buildArgumentList(Argument<?>[] arguments) {
        if (arguments == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Argument<?> argument : arguments) {
            builder.append("[").append(argument.getName()).append(" (").append(argument.getExample()).append(")],");
        }
        return arguments.length > 0 ? builder.substring(0, builder.length() - 1) : "";
    }

    @Override
    @NotNull
    public Component asComponent() {
        return this.rendered;
    }
}

