/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.task;

import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;

public class ObjectTaskRunnable<T>
implements Runnable {
    private final CompletableFuture<Void> completionFuture = new CompletableFuture();
    private final Iterator<T> iterator;
    private final RunnableVal<T> task;

    public ObjectTaskRunnable(Iterator<T> iterator, RunnableVal<T> task) {
        this.iterator = iterator;
        this.task = task;
    }

    public CompletableFuture<Void> getCompletionFuture() {
        return this.completionFuture;
    }

    @Override
    public void run() {
        boolean hasNext;
        long start = System.currentTimeMillis();
        while ((hasNext = this.iterator.hasNext()) && System.currentTimeMillis() - start < 5L) {
            this.task.value = this.iterator.next();
            this.task.run();
        }
        if (!hasNext) {
            this.completionFuture.complete(null);
        } else {
            TaskManager.runTaskLater(this, TaskTime.ticks(1L));
        }
    }
}

