/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.plotsquared.google.Binder;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.Key;
import com.plotsquared.google.Provider;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.binder.AnnotatedBindingBuilder;
import com.plotsquared.google.binder.ScopedBindingBuilder;
import com.plotsquared.google.internal.AbstractBindingBuilder;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.ConstructorBindingImpl;
import com.plotsquared.google.internal.InstanceBindingImpl;
import com.plotsquared.google.internal.LinkedBindingImpl;
import com.plotsquared.google.internal.LinkedProviderBindingImpl;
import com.plotsquared.google.internal.ProviderInstanceBindingImpl;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.Message;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Set;

public class BindingBuilder<T>
extends AbstractBindingBuilder<T>
implements AnnotatedBindingBuilder<T> {
    public BindingBuilder(Binder binder, List<Element> elements, Object source, Key<T> key) {
        super(binder, elements, source, key);
    }

    @Override
    public BindingBuilder<T> annotatedWith(Class<? extends Annotation> annotationType) {
        this.annotatedWithInternal(annotationType);
        return this;
    }

    @Override
    public BindingBuilder<T> annotatedWith(Annotation annotation) {
        this.annotatedWithInternal(annotation);
        return this;
    }

    @Override
    public BindingBuilder<T> to(Class<? extends T> implementation) {
        return this.to((Key)Key.get(implementation));
    }

    @Override
    public BindingBuilder<T> to(TypeLiteral<? extends T> implementation) {
        return this.to((Key)Key.get(implementation));
    }

    @Override
    public BindingBuilder<T> to(Key<? extends T> linkedKey) {
        Preconditions.checkNotNull(linkedKey, (Object)"linkedKey");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        this.setBinding(new LinkedBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), linkedKey));
        return this;
    }

    @Override
    public void toInstance(T instance) {
        Object injectionPoints;
        this.checkNotTargetted();
        if (instance != null) {
            try {
                injectionPoints = InjectionPoint.forInstanceMethodsAndFields(instance.getClass());
            }
            catch (ConfigurationException e) {
                this.copyErrorsToBinder(e);
                injectionPoints = (Set)e.getPartialValue();
            }
        } else {
            this.binder.addError("Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.", new Object[0]);
            injectionPoints = ImmutableSet.of();
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new InstanceBindingImpl(base.getSource(), base.getKey(), Scoping.EAGER_SINGLETON, (Set<InjectionPoint>)injectionPoints, instance));
    }

    @Override
    public BindingBuilder<T> toProvider(Provider<? extends T> provider) {
        return this.toProvider((com.plotsquared.core.annotation.inject.Provider)provider);
    }

    @Override
    public BindingBuilder<T> toProvider(com.plotsquared.core.annotation.inject.Provider<? extends T> provider) {
        Set injectionPoints;
        Preconditions.checkNotNull(provider, (Object)"provider");
        this.checkNotTargetted();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(provider.getClass());
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
            injectionPoints = (Set)e.getPartialValue();
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new ProviderInstanceBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), injectionPoints, provider));
        return this;
    }

    @Override
    public BindingBuilder<T> toProvider(Class<? extends com.plotsquared.core.annotation.inject.Provider<? extends T>> providerType) {
        return this.toProvider((Key)Key.get(providerType));
    }

    @Override
    public BindingBuilder<T> toProvider(TypeLiteral<? extends com.plotsquared.core.annotation.inject.Provider<? extends T>> providerType) {
        return this.toProvider((Key)Key.get(providerType));
    }

    @Override
    public BindingBuilder<T> toProvider(Key<? extends com.plotsquared.core.annotation.inject.Provider<? extends T>> providerKey) {
        Preconditions.checkNotNull(providerKey, (Object)"providerKey");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        this.setBinding(new LinkedProviderBindingImpl(base.getSource(), base.getKey(), base.getScoping(), providerKey));
        return this;
    }

    @Override
    public <S extends T> ScopedBindingBuilder toConstructor(Constructor<S> constructor) {
        return this.toConstructor(constructor, TypeLiteral.get(constructor.getDeclaringClass()));
    }

    @Override
    public <S extends T> ScopedBindingBuilder toConstructor(Constructor<S> constructor, TypeLiteral<? extends S> type) {
        Set injectionPoints;
        Preconditions.checkNotNull(constructor, (Object)"constructor");
        Preconditions.checkNotNull(type, (Object)"type");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(type);
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
            injectionPoints = (Set)e.getPartialValue();
        }
        try {
            InjectionPoint constructorPoint = InjectionPoint.forConstructor(constructor, type);
            this.setBinding(new ConstructorBindingImpl(base.getKey(), base.getSource(), base.getScoping(), constructorPoint, injectionPoints));
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
        }
        return this;
    }

    public String toString() {
        return "BindingBuilder<" + this.getBinding().getKey().getTypeLiteral() + ">";
    }

    private void copyErrorsToBinder(ConfigurationException e) {
        for (Message message : e.getErrorMessages()) {
            this.binder.addError(message);
        }
    }
}

