/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.Provider;
import com.plotsquared.google.internal.AbstractProcessor;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.MembersInjectorImpl;
import com.plotsquared.google.spi.MembersInjectorLookup;
import com.plotsquared.google.spi.ProviderLookup;

final class LookupProcessor
extends AbstractProcessor {
    LookupProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public <T> Boolean visit(MembersInjectorLookup<T> lookup) {
        try {
            MembersInjectorImpl<T> membersInjector = this.injector.membersInjectorStore.get(lookup.getType(), this.errors);
            lookup.initializeDelegate(membersInjector);
            this.injector.getBindingData().putMembersInjectorLookup(lookup);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> lookup) {
        try {
            Provider<T> provider = this.injector.getProviderOrThrow(lookup.getDependency(), this.errors);
            lookup.initializeDelegate(provider);
            this.injector.getBindingData().putProviderLookup(lookup);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }
}

