/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.SingleMemberInjector;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.InjectionPoint;
import java.lang.reflect.Field;

final class SingleFieldInjector
implements SingleMemberInjector {
    final Field field;
    final InjectionPoint injectionPoint;
    final Dependency<?> dependency;
    final BindingImpl<?> binding;

    public SingleFieldInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        this.field = (Field)injectionPoint.getMember();
        this.dependency = injectionPoint.getDependencies().get(0);
        this.field.setAccessible(true);
        this.binding = injector.getBindingOrThrow(this.dependency.getKey(), errors, InjectorImpl.JitLimitation.NO_JIT);
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public void inject(InternalContext context, Object o) throws InternalProvisionException {
        try {
            Object value = this.binding.getInternalFactory().get(context, this.dependency, false);
            this.field.set(o, value);
        }
        catch (InternalProvisionException e) {
            throw e.addSource(this.dependency);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

