/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotUnlinkEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.task.TaskManager;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="unlink", aliases={"u", "unmerge"}, usage="/plot unlink [createroads]", requiredType=RequiredType.PLAYER, category=CommandCategory.SETTINGS, confirmation=true)
public class Unlink
extends SubCommand {
    private final EventDispatcher eventDispatcher;

    @Inject
    public Unlink(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        boolean force;
        boolean createRoad;
        Location location = player.getLocation();
        Plot plot = location.getPlotAbs();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return false;
        }
        if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("info.plot_unowned"), new Template[0]);
            return false;
        }
        if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
            return false;
        }
        if (!plot.isMerged()) {
            player.sendMessage(TranslatableCaption.of("merge.unlink_impossible"), new Template[0]);
            return false;
        }
        if (args.length != 0) {
            if (args.length != 1 || !StringMan.isEqualIgnoreCaseToAny(args[0], "true", "false")) {
                this.sendUsage(player);
                return false;
            }
            createRoad = Boolean.parseBoolean(args[0]);
        } else {
            createRoad = true;
        }
        PlotUnlinkEvent event = this.eventDispatcher.callUnlink(plot.getArea(), plot, createRoad, createRoad, PlotUnlinkEvent.REASON.PLAYER_COMMAND);
        if (event.getEventResult() == Result.DENY) {
            player.sendMessage(TranslatableCaption.of("events.event_denied"), Template.of("value", "Unlink"));
            return true;
        }
        boolean bl = force = event.getEventResult() == Result.FORCE;
        if (!(force || plot.isOwner(player.getUUID()) || Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_COMMAND_UNLINK))) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
            return true;
        }
        Runnable runnable = () -> {
            if (!plot.getPlotModificationManager().unlinkPlot(createRoad, createRoad)) {
                player.sendMessage(TranslatableCaption.of("merge.unmerge_cancelled"), new Template[0]);
                return;
            }
            player.sendMessage(TranslatableCaption.of("merge.unlink_success"), new Template[0]);
            this.eventDispatcher.callPostUnlink(plot, PlotUnlinkEvent.REASON.PLAYER_COMMAND);
        };
        if (this.hasConfirmation(player)) {
            CmdConfirm.addPending(player, "/plot unlink " + plot.getId(), runnable);
        } else {
            TaskManager.runTask(runnable);
        }
        return true;
    }
}

