/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.database;

import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.util.task.RunnableVal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface AbstractDB {
    public static final UUID everyone = UUID.fromString("1-1-3-3-7");

    public void setOwner(Plot var1, UUID var2);

    public void createPlotsAndData(List<Plot> var1, Runnable var2);

    public void createPlotSafe(Plot var1, Runnable var2, Runnable var3);

    public void createTables() throws Exception;

    public void delete(Plot var1);

    public void deleteSettings(Plot var1);

    public void deleteHelpers(Plot var1);

    public void deleteTrusted(Plot var1);

    public void deleteDenied(Plot var1);

    public void deleteComments(Plot var1);

    public void deleteRatings(Plot var1);

    public void delete(PlotCluster var1);

    public void addPersistentMeta(UUID var1, String var2, byte[] var3, boolean var4);

    public void removePersistentMeta(UUID var1, String var2);

    public void getPersistentMeta(UUID var1, RunnableVal<Map<String, byte[]>> var2);

    public void createPlotSettings(int var1, Plot var2);

    public int getId(Plot var1);

    public int getClusterId(PlotCluster var1);

    public boolean convertFlags();

    public HashMap<String, HashMap<PlotId, Plot>> getPlots();

    public void validateAllPlots(Set<Plot> var1);

    public HashMap<String, Set<PlotCluster>> getClusters();

    public void setMerged(Plot var1, boolean[] var2);

    public CompletableFuture<Boolean> swapPlots(Plot var1, Plot var2);

    public void setFlag(Plot var1, PlotFlag<?, ?> var2);

    public void removeFlag(Plot var1, PlotFlag<?, ?> var2);

    public void setClusterName(PlotCluster var1, String var2);

    public void setAlias(Plot var1, String var2);

    public void purgeIds(Set<Integer> var1);

    public void purge(PlotArea var1, Set<PlotId> var2);

    public void setPosition(Plot var1, String var2);

    public void setPosition(PlotCluster var1, String var2);

    public void removeTrusted(Plot var1, UUID var2);

    public void removeHelper(PlotCluster var1, UUID var2);

    public void removeMember(Plot var1, UUID var2);

    public void removeInvited(PlotCluster var1, UUID var2);

    public void setTrusted(Plot var1, UUID var2);

    public void setHelper(PlotCluster var1, UUID var2);

    public void setMember(Plot var1, UUID var2);

    public void setInvited(PlotCluster var1, UUID var2);

    public void removeDenied(Plot var1, UUID var2);

    public void setDenied(Plot var1, UUID var2);

    public HashMap<UUID, Integer> getRatings(Plot var1);

    public void setRating(Plot var1, UUID var2, int var3);

    public void removeComment(Plot var1, PlotComment var2);

    public void clearInbox(Plot var1, String var2);

    public void setComment(Plot var1, PlotComment var2);

    public void getComments(@NonNull Plot var1, String var2, RunnableVal<List<PlotComment>> var3);

    public void createPlotAndSettings(Plot var1, Runnable var2);

    public void createCluster(PlotCluster var1);

    public void resizeCluster(PlotCluster var1, PlotId var2, PlotId var3);

    public void movePlot(Plot var1, Plot var2);

    public void replaceUUID(UUID var1, UUID var2);

    public boolean deleteTables();

    public void close();

    public void replaceWorld(String var1, String var2, PlotId var3, PlotId var4);

    public void updateTables(int[] var1);
}

