/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.location;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.World;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.khelekore.prtree.MBR;
import org.khelekore.prtree.SimpleMBR;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class Location
extends BlockLoc
implements Comparable<Location> {
    private final float yaw;
    private final float pitch;
    private final BlockVector3 blockVector3;
    private final World<?> world;

    protected Location(@NonNull World<?> world, @NonNull BlockVector3 blockVector3, float yaw, float pitch) {
        super(blockVector3.getX(), blockVector3.getY(), blockVector3.getZ(), yaw, pitch);
        this.world = (World)Preconditions.checkNotNull(world, (Object)"World may not be null");
        this.blockVector3 = (BlockVector3)Preconditions.checkNotNull((Object)blockVector3, (Object)"Vector may not be null");
        this.yaw = yaw;
        this.pitch = pitch;
    }

    private Location(@NonNull String worldName, @NonNull BlockVector3 blockVector3, float yaw, float pitch) {
        super(blockVector3.getX(), blockVector3.getY(), blockVector3.getZ(), yaw, pitch);
        Preconditions.checkNotNull((Object)worldName, (Object)"World name may not be null");
        this.world = worldName.isEmpty() ? World.nullWorld() : PlotSquared.platform().getPlatformWorld(worldName);
        this.blockVector3 = (BlockVector3)Preconditions.checkNotNull((Object)blockVector3, (Object)"Vector may not be null");
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public static @NonNull Location at(@NonNull String world, @NonNull BlockVector3 blockVector3, float yaw, float pitch) {
        return new Location(world, blockVector3, yaw, pitch);
    }

    public static @NonNull Location at(@NonNull String world, @NonNull BlockVector3 blockVector3) {
        return Location.at(world, blockVector3, 0.0f, 0.0f);
    }

    public static @NonNull Location at(@NonNull String world, int x, int y, int z, float yaw, float pitch) {
        return Location.at(world, BlockVector3.at((int)x, (int)y, (int)z), yaw, pitch);
    }

    public static @NonNull Location at(@NonNull String world, int x, int y, int z) {
        return Location.at(world, BlockVector3.at((int)x, (int)y, (int)z));
    }

    public static @NonNull Location at(@NonNull World<?> world, @NonNull BlockVector3 blockVector3, float yaw, float pitch) {
        return new Location(world, blockVector3, yaw, pitch);
    }

    public static @NonNull Location at(@NonNull World<?> world, @NonNull BlockVector3 blockVector3) {
        return Location.at(world, blockVector3, 0.0f, 0.0f);
    }

    public static @NonNull Location at(@NonNull World<?> world, int x, int y, int z, float yaw, float pitch) {
        return Location.at(world, BlockVector3.at((int)x, (int)y, (int)z), yaw, pitch);
    }

    public static @NonNull Location at(@NonNull World<?> world, int x, int y, int z) {
        return Location.at(world, BlockVector3.at((int)x, (int)y, (int)z));
    }

    public @NonNull World<?> getWorld() {
        return this.world;
    }

    public @NonNull String getWorldName() {
        return this.world.getName();
    }

    @Override
    public int getX() {
        return this.blockVector3.getBlockX();
    }

    @Override
    public int getY() {
        return this.blockVector3.getY();
    }

    @Override
    public int getZ() {
        return this.blockVector3.getZ();
    }

    public @Nullable PlotArea getPlotArea() {
        return PlotSquared.get().getPlotAreaManager().getPlotArea(this);
    }

    public @Nullable Plot getOwnedPlot() {
        PlotArea area = this.getPlotArea();
        if (area != null) {
            return area.getOwnedPlot(this);
        }
        return null;
    }

    public @Nullable Plot getOwnedPlotAbs() {
        PlotArea area = this.getPlotArea();
        if (area != null) {
            return area.getOwnedPlotAbs(this);
        }
        return null;
    }

    public boolean isPlotArea() {
        return this.getPlotArea() != null;
    }

    public boolean isPlotRoad() {
        PlotArea area = this.getPlotArea();
        return area != null && area.getPlotAbs(this) == null;
    }

    public boolean isUnownedPlotArea() {
        PlotArea area = this.getPlotArea();
        return area != null && area.getOwnedPlotAbs(this) == null;
    }

    public @Nullable Plot getPlotAbs() {
        PlotArea area = this.getPlotArea();
        if (area != null) {
            return area.getPlotAbs(this);
        }
        return null;
    }

    public @Nullable Plot getPlot() {
        PlotArea area = this.getPlotArea();
        if (area != null) {
            return area.getPlot(this);
        }
        return null;
    }

    public @NonNull BlockVector2 getChunkLocation() {
        return BlockVector2.at((int)(this.getX() >> 4), (int)(this.getZ() >> 4));
    }

    public @NonNull Location add(int x, int y, int z) {
        return new Location(this.world, this.blockVector3.add(x, y, z), this.yaw, this.pitch);
    }

    public @NonNull Location withX(int x) {
        return new Location(this.world, this.blockVector3.withX(x), this.yaw, this.pitch);
    }

    public @NonNull Location withY(int y) {
        return new Location(this.world, this.blockVector3.withY(y), this.yaw, this.pitch);
    }

    public @NonNull Location withZ(int z) {
        return new Location(this.world, this.blockVector3.withZ(z), this.yaw, this.pitch);
    }

    public @NonNull Location withYaw(float yaw) {
        return new Location(this.world, this.blockVector3, yaw, this.pitch);
    }

    public @NonNull Location withPitch(float pitch) {
        return new Location(this.world, this.blockVector3, this.yaw, pitch);
    }

    public @NonNull Location withWorld(@NonNull String world) {
        return new Location(world, this.blockVector3, this.yaw, this.pitch);
    }

    public double getEuclideanDistanceSquared(@NonNull Location l2) {
        double x = this.getX() - l2.getX();
        double y = this.getY() - l2.getY();
        double z = this.getZ() - l2.getZ();
        return x * x + y * y + z * z;
    }

    public double getEuclideanDistance(@NonNull Location l2) {
        return Math.sqrt(this.getEuclideanDistanceSquared(l2));
    }

    public @NonNull Location subtract(int x, int y, int z) {
        return this.add(-x, -y, -z);
    }

    public @NonNull MBR toMBR() {
        return new SimpleMBR(this.getX(), this.getX(), this.getY(), this.getY(), this.getZ(), this.getZ());
    }

    @Override
    public int compareTo(@NonNull Location o) {
        if (this.getX() == o.getX() && this.getY() == o.getY() || this.getZ() == o.getZ()) {
            return 0;
        }
        if (this.getX() < o.getX() && this.getY() < o.getY() && this.getZ() < o.getZ()) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Location location = (Location)o;
        return Float.compare(location.getYaw(), this.getYaw()) == 0 && Float.compare(location.getPitch(), this.getPitch()) == 0 && Objects.equal((Object)this.getBlockVector3(), (Object)location.getBlockVector3()) && Objects.equal(this.getWorld(), location.getWorld());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), Float.valueOf(this.getYaw()), Float.valueOf(this.getPitch()), this.getBlockVector3(), this.getWorld()});
    }

    @Override
    public String toString() {
        return "\"plotsquaredlocation\":{\"x\":" + this.getX() + ",\"y\":" + this.getY() + ",\"z\":" + this.getZ() + ",\"yaw\":" + this.yaw + ",\"pitch\":" + this.pitch + ",\"world\":\"" + this.world + "\"}";
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    public BlockVector3 getBlockVector3() {
        return this.blockVector3;
    }
}

