/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.types.NumberFlag;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class DoubleFlag<F extends NumberFlag<Double, F>>
extends NumberFlag<Double, F> {
    protected DoubleFlag(@NonNull Double value, Double minimum, Double maximum, @NonNull Caption flagDescription) {
        super(value, minimum, maximum, TranslatableCaption.of("flags.flag_category_doubles"), flagDescription);
    }

    protected DoubleFlag(@NonNull Double value, @NonNull Caption flagDescription) {
        this(value, (Double)Double.MIN_VALUE, (Double)Double.MAX_VALUE, flagDescription);
    }

    @Override
    public F merge(@NonNull Double newValue) {
        return (F)((NumberFlag)this.flagOf((Double)this.getValue() + newValue));
    }

    @Override
    public String getExample() {
        return "12.175";
    }

    @Override
    public String toString() {
        return ((Double)this.getValue()).toString();
    }

    @Override
    protected @NonNull Double parseNumber(String input) throws FlagParseException {
        try {
            return Double.parseDouble(input);
        }
        catch (Throwable throwable) {
            throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_double"), new Template[0]);
        }
    }

    @Override
    public boolean isValuedPermission() {
        return false;
    }
}

