/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.types.NumberFlag;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class LongFlag<F extends NumberFlag<Long, F>>
extends NumberFlag<Long, F> {
    protected LongFlag(@NonNull Long value, Long minimum, Long maximum, @NonNull Caption flagDescription) {
        super(value, minimum, maximum, TranslatableCaption.of("flags.flag_category_integers"), flagDescription);
    }

    protected LongFlag(@NonNull Long value, @NonNull Caption flagDescription) {
        this(value, Long.MIN_VALUE, Long.MAX_VALUE, flagDescription);
    }

    @Override
    public F merge(@NonNull Long newValue) {
        return (F)((NumberFlag)this.flagOf((Long)this.getValue() + newValue));
    }

    @Override
    public String toString() {
        return ((Long)this.getValue()).toString();
    }

    @Override
    public String getExample() {
        return "123456789";
    }

    @Override
    protected @NonNull Long parseNumber(String input) throws FlagParseException {
        try {
            return Long.parseLong(input);
        }
        catch (Throwable throwable) {
            throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_long"), new Template[0]);
        }
    }

    @Override
    public boolean isValuedPermission() {
        return false;
    }
}

